/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.net;

import com.google.common.base.MoreObjects;
import com.simsilica.net.ChatSessionListener;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatMessage
implements Serializable {
    static Logger log = LoggerFactory.getLogger(ChatMessage.class);
    public static final int TYPE_JOINED = -1;
    public static final int TYPE_LEFT = -2;
    public static final int TYPE_MESSAGE = 0;
    private int type;
    private int clientId;
    private String playerName;
    private String message;

    public ChatMessage(int type, int clientId, String playerName, String message) {
        this.type = type;
        this.clientId = clientId;
        this.playerName = playerName;
        this.message = message;
    }

    public ChatMessage(int clientId, String playerName, String message) {
        this(0, clientId, playerName, message);
    }

    public ChatMessage(int type, int clientId, String playerName) {
        this(type, clientId, playerName, null);
    }

    public static ChatMessage joined(int clientId, String playerName) {
        return new ChatMessage(-1, clientId, playerName);
    }

    public static ChatMessage left(int clientId, String playerName) {
        return new ChatMessage(-2, clientId, playerName);
    }

    public int getType() {
        return this.type;
    }

    public int getClientId() {
        return this.clientId;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getMessage() {
        return this.message;
    }

    public void deliver(ChatSessionListener l) {
        switch (this.type) {
            case -1: {
                l.playerJoined(this.clientId, this.playerName);
                break;
            }
            case -2: {
                l.playerLeft(this.clientId, this.playerName);
                break;
            }
            default: {
                l.newMessage(this.clientId, this.playerName, this.message);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (other.clientId != this.clientId) {
            return false;
        }
        if (!Objects.equals(other.playerName, this.playerName)) {
            return false;
        }
        return Objects.equals(other.message, this.message);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("type", this.type).add("clientId", this.clientId).add("playerName", (Object)this.playerName).add("message", (Object)this.message).toString();
    }
}

