/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

public class SimTime {
    private long frame;
    private long lastRealTime;
    private boolean rebase;
    private long gameTime;
    private double tpf;
    private double invTimeScale = 1.0E9;
    private double timeScale = 1.0 / this.invTimeScale;

    public void update(long realTime) {
        long timeDelta;
        if (this.frame == 0L || this.rebase) {
            timeDelta = 0L;
            this.rebase = false;
        } else {
            timeDelta = realTime - this.lastRealTime;
        }
        this.lastRealTime = realTime;
        ++this.frame;
        this.tpf = (double)timeDelta * this.timeScale;
        this.gameTime += timeDelta;
    }

    public long getUnlockedTime(long realTime) {
        long timeDelta = this.frame == 0L || this.rebase ? 0L : realTime - this.lastRealTime;
        return this.gameTime + timeDelta;
    }

    public long toSimTime(double seconds) {
        return (long)(seconds * this.invTimeScale);
    }

    public long getFutureTime(double seconds) {
        return this.gameTime + this.toSimTime(seconds);
    }

    public final double getTpf() {
        return this.tpf;
    }

    public final long getFrame() {
        return this.frame;
    }

    public final long getTime() {
        return this.gameTime;
    }

    public final void setCurrentTime(long time) {
        this.gameTime = time;
        this.rebase = true;
    }

    public final double getTimeInSeconds() {
        return (double)this.gameTime * this.timeScale;
    }

    public final double getTimeScale() {
        return this.timeScale;
    }

    public final long addMillis(long ms) {
        return this.gameTime + ms * 1000000L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[tpf=" + this.getTpf() + ", seconds=" + this.getTimeInSeconds() + "]";
    }
}

