/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock;

import com.google.common.base.MoreObjects;
import com.simsilica.mblock.SubstanceName;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Substance
implements Serializable {
    static final long serialVersionUID = 42L;
    static Logger log = LoggerFactory.getLogger(Substance.class);
    private SubstanceName name;
    private double amount;

    private Substance() {
    }

    public Substance(String name, double amount) {
        this(new SubstanceName(name), amount);
    }

    public Substance(SubstanceName name, double amount) {
        this.name = name;
        this.amount = amount;
    }

    public void setName(SubstanceName name) {
        this.name = name;
    }

    public SubstanceName getName() {
        return this.name;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public double getAmount() {
        return this.amount;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.amount);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Substance other = (Substance)o;
        if (!Objects.equals(other.name, this.name)) {
            return false;
        }
        return !(Math.abs(other.amount - this.amount) > 1.0E-7);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("amount", this.amount).toString();
    }
}

