/*
 * Decompiled with CFR 0.152.
 */
package mythruna.fabric.io;

import com.google.common.base.Charsets;
import com.simsilica.mblock.io.UpdateableData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mythruna.fabric.SwatchName;
import mythruna.fabric.SwatchShape;
import mythruna.fabric.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwatchShapeData
implements UpdateableData<SwatchShapeData>,
Serializable {
    private static final long serialVersionUID = 42L;
    public static final long formatVersion = 43L;
    static Logger log = LoggerFactory.getLogger(SwatchShapeData.class);
    public int badShapeIndex;
    public SwatchShape[] shapes;
    public Map<Transform, Map<SwatchName, List<SwatchName>>> transforms;

    public SwatchShapeData() {
    }

    public SwatchShapeData(SwatchShape[] shapes, int badShapeIndex, Map<Transform, Map<SwatchName, List<SwatchName>>> transforms) {
        this.shapes = shapes;
        this.badShapeIndex = badShapeIndex;
        this.transforms = transforms;
    }

    public boolean update(SwatchShapeData update) {
        if (Arrays.asList(this.shapes).equals(Arrays.asList(update.shapes)) && Objects.equals(this.transforms, update.transforms)) {
            return false;
        }
        String updateBadShape = null;
        if (update.badShapeIndex >= 0 && update.badShapeIndex < update.shapes.length) {
            SwatchShape bt = update.shapes[update.badShapeIndex];
            updateBadShape = bt != null ? bt.getFullName() : null;
        }
        String badShape = null;
        if (this.badShapeIndex >= 0 && this.badShapeIndex < this.shapes.length) {
            SwatchShape bt = this.shapes[this.badShapeIndex];
            badShape = bt != null ? bt.getFullName() : null;
        }
        HashMap<String, SwatchShape> index = new HashMap<String, SwatchShape>();
        for (SwatchShape shape : this.shapes) {
            if (shape == null) continue;
            index.put(shape.getFullName(), shape);
        }
        ArrayList<SwatchShape> newShapes = new ArrayList<SwatchShape>(Arrays.asList(this.shapes));
        for (SwatchShape shape : update.shapes) {
            if (shape == null) continue;
            SwatchShape existing = (SwatchShape)index.get(shape.getFullName());
            if (existing == null) {
                log.info("New shape:" + shape.getFullName());
                newShapes.add(shape);
                index.put(shape.getFullName(), shape);
                continue;
            }
            if (Objects.equals(shape, existing)) continue;
            log.info("Replacing:" + existing.getFullName());
            int i = newShapes.indexOf(existing);
            if (i < 0) {
                throw new RuntimeException("Data format error: existing shape not found in shape list, shape:" + existing.getFullName());
            }
            newShapes.set(i, shape);
            index.put(shape.getFullName(), shape);
        }
        if (!Objects.equals(badShape, updateBadShape)) {
            log.info("Updating bad shape index, old shape:" + badShape + " new shape:" + updateBadShape);
            SwatchShape bad = updateBadShape == null ? null : (SwatchShape)index.get(updateBadShape);
            this.badShapeIndex = newShapes.indexOf(bad);
            log.info("New bad shape index:" + this.badShapeIndex);
        }
        this.shapes = newShapes.toArray(new SwatchShape[0]);
        if (update.transforms != null) {
            if (this.transforms != null) {
                for (Transform xform : update.transforms.keySet()) {
                    Map<SwatchName, List<SwatchName>> values = update.transforms.get((Object)xform);
                    Map<SwatchName, List<SwatchName>> existing = this.transforms.get((Object)xform);
                    if (existing != null) {
                        existing.putAll(values);
                        continue;
                    }
                    this.transforms.put(xform, values);
                }
            } else {
                this.transforms = update.transforms;
            }
            log.info("Latest transforms:" + this.transforms);
        }
        return true;
    }

    public static SwatchShapeData load(InputStream rawIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(rawIn);){
            SwatchShapeData result = new SwatchShapeData();
            long version = in.readLong();
            log.info("version:" + version);
            if (version < 43L) {
                try {
                    result.shapes = (SwatchShape[])in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Error resolving shapes", e);
                }
                result.badShapeIndex = in.readInt();
            } else {
                try {
                    result = (SwatchShapeData)in.readObject();
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Error resolving shapes", e);
                }
            }
            SwatchShapeData swatchShapeData = result;
            return swatchShapeData;
        }
    }

    public static SwatchShapeData load(String resource) throws IOException {
        URL u = SwatchShapeData.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return SwatchShapeData.load(u.openStream());
    }

    public static SwatchShapeData load(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        return SwatchShapeData.load(new FileInputStream(f));
    }

    public static SwatchShapeData fromBytes(byte[] bytes) {
        SwatchShapeData swatchShapeData;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            SwatchShapeData data;
            swatchShapeData = data = SwatchShapeData.load(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Error converting bytes to SwatchShapeData", e);
            }
        }
        in.close();
        return swatchShapeData;
    }

    public static void store(SwatchShapeData data, File f) throws IOException {
        SwatchShapeData.store(data, new FileOutputStream(f));
    }

    public static void store(SwatchShapeData data, OutputStream rawOut) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(rawOut);){
            out.writeLong(43L);
            out.writeObject(data);
        }
    }

    public static byte[] toBytes(SwatchShapeData data) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            SwatchShapeData.store(data, bos);
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Error converting SwatchShapeData to bytes", e);
        }
    }

    public void writeIndex(File f) throws IOException {
        FileOutputStream fOut = new FileOutputStream(f);
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)fOut, Charsets.UTF_8));){
            out.println("# Generated:" + String.format("%1$tF %1$tT", new Date()));
            for (int i = 0; i < this.shapes.length; ++i) {
                SwatchShape shape = this.shapes[i];
                if (shape == null) continue;
                out.println("[" + i + "] " + shape.getFullName());
            }
        }
    }
}

