/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.Substance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mythruna.mblock.SubstanceType;
import mythruna.mblock.io.SubstanceTypeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubstanceTypeIndex {
    static Logger log = LoggerFactory.getLogger(SubstanceTypeIndex.class);
    private static SubstanceType[] types;
    private static int typeCount;
    private static SubstanceType badType;
    private static int badTypeIndex;
    private static Set<SubstanceType> baseTypes;
    private static Map<String, SubstanceType> typeIndex;
    private static LoadingCache<Integer, List<Substance>> ingredientCache;

    private SubstanceTypeIndex() {
    }

    public static void initialize(SubstanceTypeData data) {
        SubstanceTypeIndex.initialize(data.types, data.badTypeIndex);
    }

    public static void initialize(SubstanceType[] types, int badTypeIndex) {
        log.info("initialize(size:" + types.length + ")");
        if (SubstanceTypeIndex.types != null) {
            throw new IllegalStateException("SubstanceTypeIndex is already initialized");
        }
        SubstanceTypeIndex.types = types;
        typeCount = types.length;
        SubstanceTypeIndex.badTypeIndex = badTypeIndex;
        badType = types[badTypeIndex];
        for (SubstanceType type : types) {
            if (type == null) continue;
            typeIndex.put(type.getName(), type);
            if (type.getMix() != null && type.getMix().length != 0) continue;
            baseTypes.add(type);
        }
    }

    public static SubstanceTypeData toData() {
        return new SubstanceTypeData(types, badTypeIndex);
    }

    public static void reset() {
        types = null;
        typeCount = 0;
        badTypeIndex = 0;
        badType = null;
        typeIndex.clear();
    }

    public static Collection<String> getNames() {
        return typeIndex.keySet();
    }

    public static SubstanceType get(String name) {
        return typeIndex.get(name);
    }

    public static SubstanceType get(int type) {
        if (type >= 0 && type < typeCount) {
            return types[type];
        }
        return badType;
    }

    public static void setBadTypeIndex(int index) {
        badTypeIndex = index;
    }

    public static int getBadTypeIndex() {
        return badTypeIndex;
    }

    public static void override(int index, SubstanceType type) {
        SubstanceTypeIndex.types[index] = type;
    }

    public static boolean isInitialized() {
        return types != null;
    }

    public static int getTypeCount() {
        return typeCount;
    }

    public static SubstanceType[] getTypes() {
        return types;
    }

    public static Set<SubstanceType> getBaseTypes() {
        return baseTypes;
    }

    public static List<Substance> findSubstances(int type) {
        return (List)ingredientCache.getUnchecked((Object)type);
    }

    protected static List<Substance> findParts(int type) {
        return new PartCollector((int)type).parts;
    }

    static {
        baseTypes = new HashSet<SubstanceType>();
        typeIndex = new HashMap<String, SubstanceType>();
        ingredientCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Integer, List<Substance>>(){

            public List<Substance> load(Integer key) {
                return SubstanceTypeIndex.findParts(key);
            }
        });
    }

    private static class PartCollector {
        private BlockType blockType;
        private List<Substance> parts = new ArrayList<Substance>();
        private Set<SubstanceType> visited = new HashSet<SubstanceType>();

        public PartCollector(int type) {
            this.blockType = BlockTypeIndex.get((int)type);
            Substance[] mix = this.blockType.getSubstances();
            if (mix != null && mix.length > 0) {
                for (Substance sub : mix) {
                    this.collectParts(sub, 1.0);
                }
            }
        }

        protected void collectParts(Substance substance, double scale) {
            SubstanceType type = SubstanceTypeIndex.get(substance.getName().getName());
            if (type == null) {
                log.error("Missing type for:" + substance);
                return;
            }
            if (!this.visited.add(type)) {
                log.error("Loop detected in substance recursion at:" + substance);
                return;
            }
            double localScale = scale * substance.getAmount();
            Substance[] mix = type.getMix();
            if (mix != null && mix.length > 0) {
                for (Substance child : mix) {
                    this.collectParts(child, localScale);
                }
            } else {
                this.parts.add(new Substance(substance.getName(), localScale));
            }
        }
    }
}

