/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.DynArray;
import com.simsilica.mphys.RigidBody;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.es.AgentType;
import mythruna.es.DebugText;
import mythruna.es.LocationRelationship;
import mythruna.es.ObjectTypeInfo;
import mythruna.es.StatusText;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.AgentDriver;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Behaviors;
import mythruna.sim.ai.BodyPositionMob;
import mythruna.sim.ai.BrainConfigurations;
import mythruna.sim.ai.CompositeSignalHandler;
import mythruna.sim.ai.Mob;
import mythruna.sim.ai.PerceptionSet;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.ShortTermMemory;
import mythruna.sim.ai.Signal;
import mythruna.sim.ai.SignalGenerator;
import mythruna.sim.ai.SignalHandler;
import mythruna.sim.ai.SignalQueue;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Brain {
    static Logger log = LoggerFactory.getLogger(Brain.class);
    private EntityData ed;
    private AgentDriver agent;
    private ObjectTypeInfo objectType;
    private AgentType agentType;
    private long lastFrameTime;
    private double brainTime;
    private Behavior defaultBehavior = Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0));
    private Behavior currentBehavior;
    private String debugText;
    private String behaviorName;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private final Behavior standStill;
    private SignalQueue signals = new SignalQueue();
    private CompositeSignalHandler signalHandlers = new CompositeSignalHandler();
    private DynArray<SignalGenerator> signalGenerators = new DynArray(SignalGenerator.class);
    private DynArray<ShortTermMemory> memoryArray = new DynArray(ShortTermMemory.class);

    public Brain(EntityData ed, final AgentDriver agent) {
        this.ed = ed;
        this.agent = agent;
        this.objectType = (ObjectTypeInfo)ed.getComponent(agent.getEntityId(), ObjectTypeInfo.class);
        this.agentType = (AgentType)ed.getComponent(agent.getEntityId(), AgentType.class);
        agent.setNearPerception(new Vec3d(0.0, 0.25, 1.0), 3.0);
        agent.setFarPerception(new Vec3d(0.0, 0.25, 2.0), 12.0);
        this.signalGenerators.add((brain, frameTime, step) -> {
            PerceptionSet perception = agent.getSightPerceptionSet();
            for (AbstractBody<EntityId, MBlockShape> body : perception.getEntered()) {
                if (!(body instanceof RigidBody)) continue;
                this.signals.add(new Signal<RigidBody>("EnteredView", (RigidBody)body));
            }
            for (AbstractBody<EntityId, MBlockShape> body : perception.getExited()) {
                if (!(body instanceof RigidBody)) continue;
                this.signals.add(new Signal<RigidBody>("ExitedView", (RigidBody)body));
            }
            perception.clearPendingState();
        });
        this.signalGenerators.add((brain, frameTime, step) -> {
            PerceptionSet perception = agent.getPersonalSpaceSet();
            for (AbstractBody<EntityId, MBlockShape> body : perception.getEntered()) {
                if (!(body instanceof RigidBody)) continue;
                this.signals.add(new Signal<RigidBody>("EnteredSpace", (RigidBody)body));
            }
            for (AbstractBody<EntityId, MBlockShape> body : perception.getExited()) {
                if (!(body instanceof RigidBody)) continue;
                this.signals.add(new Signal<RigidBody>("ExitedSpace", (RigidBody)body));
            }
            perception.clearPendingState();
        });
        this.standStill = new AbstractBehavior(){

            @Override
            protected void onStart(Brain brain) {
                Brain.this.behaviorName = "Stand Still";
                agent.setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
                agent.setDefaultAction("Idle");
            }

            @Override
            public boolean update(long frameTime, double step) {
                return true;
            }
        };
    }

    public EntityId getEntityId() {
        return this.agent.getEntityId();
    }

    public AgentDriver getAgent() {
        return this.agent;
    }

    public Vec3d getInitialPosition() {
        return this.getProperty("home", null);
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public <T> T getProperty(String name, T defaultValue) {
        Object value = this.properties.get(name);
        if (value == null) {
            this.properties.put(name, defaultValue);
            return defaultValue;
        }
        return (T)value;
    }

    public boolean addShortTermMemory(String name, Object value, double duration) {
        ShortTermMemory<Object> mem = this.getProperty(name, null);
        if (mem == null) {
            mem = new ShortTermMemory<Object>(0.2);
            this.setProperty(name, mem);
            this.memoryArray.add(mem);
        }
        return mem.add(value, this.brainTime + duration);
    }

    public boolean refreshShortTermMemory(String name, Object value, double duration) {
        ShortTermMemory mem = this.getProperty(name, null);
        if (mem == null) {
            return false;
        }
        return mem.updateIfExists(value, this.brainTime + duration);
    }

    public boolean hasShortTermMemory(String name, Object value) {
        ShortTermMemory mem = this.getProperty(name, null);
        if (mem == null) {
            return false;
        }
        return mem.contains(value);
    }

    public boolean isSameType(EntityId id) {
        AgentType otherType = (AgentType)this.ed.getComponent(id, AgentType.class);
        if (otherType == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("isSameType(" + id + "):" + otherType.toString(this.ed) + "  us:" + this.objectType.toString(this.ed));
        }
        return this.agentType.getTypeId() == otherType.getTypeId();
    }

    public double adjustProperty(String name, double delta) {
        double value = this.getProperty(name, 0.0);
        this.setProperty(name, value += delta);
        return value;
    }

    public void signal(Signal signal) {
        this.signals.add(signal);
    }

    public void signal(String signal, Object ... args) {
        if (log.isTraceEnabled()) {
            log.trace("signal(" + signal + ", " + Arrays.asList(args) + ")");
        }
        if ("Talking".equals(signal)) {
            EntityId converser = (EntityId)args[0];
            log.info("Stand still and face:" + converser);
            this.signals.add(new Signal<EntityId>("Talk", converser));
        } else if ("Done Talking".equals(signal)) {
            if (args.length > 1) {
                log.info("Saying:" + args[1]);
                this.say(String.valueOf(args[1]));
            }
            EntityId converser = (EntityId)args[0];
            this.signals.add(new Signal<EntityId>("TalkStop", converser));
        } else if ("Pet".equals(signal)) {
            EntityId petter = (EntityId)args[0];
            this.signals.add(new Signal<EntityId>("Pet", petter));
        } else if ("Reset".equals(signal)) {
            this.loadSettings();
        } else {
            log.info("Unhandled signal:" + signal);
        }
    }

    public void setAgentType(String type, int level) {
        if (log.isTraceEnabled()) {
            log.trace("setAgentType(" + type + ", " + level + ")");
        }
        if ("Gaefen".equals(type)) {
            BrainConfigurations.configureGaefen(this);
        } else if ("Bird".equals(type)) {
            BrainConfigurations.configureBird(this);
        } else if ("Butterfly".equals(type)) {
            BrainConfigurations.configureButterfly(this);
        } else if ("Dog".equals(type)) {
            BrainConfigurations.configureDog(this);
        } else {
            BrainConfigurations.configureNpc(this);
        }
        this.loadSettings();
    }

    protected void loadSettings() {
        EntityId agentId = this.agent.getEntityId();
        EntityId homeId = this.ed.findEntity(LocationRelationship.sourceFilter(agentId), new Class[]{LocationRelationship.class});
        if (homeId != null) {
            this.setProperty("home", ((LocationRelationship)this.ed.getComponent(homeId, LocationRelationship.class)).getLocation());
        } else {
            this.setProperty("home", null);
        }
        log.info("Setting home to:" + this.getProperty("home", null));
    }

    protected void setDebugText(String debugText) {
        if (Objects.equals(this.debugText, debugText)) {
            return;
        }
        this.debugText = debugText;
        this.ed.setComponent(this.agent.getEntityId(), (EntityComponent)new DebugText(debugText));
    }

    public void say(String text) {
        this.agent.getChatProvider().say(text);
        this.say(text, this.lastFrameTime, 4.0);
    }

    protected void say(String text, long startTime, double duration) {
        this.setStatusText(0, "\"" + text + "\"", startTime, duration);
    }

    protected void setStatusText(int type, String text, long startTime, double duration) {
        if (log.isTraceEnabled()) {
            log.trace(this.agent.getEntityId() + " - setStatusText(" + type + ", " + text + ", " + startTime + ", " + duration + ")");
        }
        this.ed.setComponent(this.agent.getEntityId(), (EntityComponent)new StatusText(type, text, startTime, duration));
    }

    public Mob getMob(EntityId entityId) {
        return BodyPositionMob.create(this.ed, entityId);
    }

    public void addSignalGenerator(SignalGenerator generator) {
        this.signalGenerators.add((Object)generator);
    }

    public void onSignal(Signal<?> signalExample, SignalHandler handler) {
        this.signalHandlers.addDelegate(signalExample.getClass(), signalExample.getType(), handler);
    }

    public void onSignal(String type, SignalHandler handler) {
        this.signalHandlers.addDelegate(type, handler);
    }

    public <T> void onSignal(Class<Signal<T>> signalClass, String type, SignalHandler<T> handler) {
        this.signalHandlers.addDelegate(signalClass, type, handler);
    }

    public void setDefaultBehavior(Behavior defaultBehavior) {
        if (this.defaultBehavior == defaultBehavior) {
            return;
        }
        boolean isRunning = this.defaultBehavior != null && this.defaultBehavior == this.currentBehavior;
        this.defaultBehavior = defaultBehavior;
        if (isRunning) {
            this.setCurrentBehavior(null);
        }
    }

    public Behavior getDefaultBehavior() {
        return this.defaultBehavior;
    }

    public void setCurrentBehavior(Behavior currentBehavior) {
        if (this.currentBehavior != null && this.currentBehavior == currentBehavior) {
            return;
        }
        if (this.currentBehavior != null) {
            this.currentBehavior.stop();
        }
        if (currentBehavior == null) {
            this.behaviorName = "default";
        }
        Behavior behavior = this.currentBehavior = currentBehavior == null ? this.defaultBehavior : currentBehavior;
        if (this.currentBehavior != null) {
            this.currentBehavior.start(this);
        }
    }

    public Behavior getCurrentBehavior() {
        return this.currentBehavior;
    }

    protected boolean isIdle() {
        return this.currentBehavior == null || this.currentBehavior == this.defaultBehavior;
    }

    protected Reaction generateReaction(Signal signal) {
        Reaction reaction;
        if (this.currentBehavior != this.defaultBehavior && this.currentBehavior != null && (reaction = this.currentBehavior.generateReaction(this, signal)) != null) {
            return reaction;
        }
        return this.signalHandlers.generateReaction(this, signal);
    }

    protected boolean setReaction(Reaction reaction) {
        Behavior newBehavior = reaction.getBehavior();
        if (newBehavior == null) {
            return false;
        }
        this.behaviorName = reaction.getDebugName();
        this.setCurrentBehavior(newBehavior);
        return true;
    }

    protected void generateSignals(long frameTime, double step) {
        for (SignalGenerator gen : (SignalGenerator[])this.signalGenerators.getArray()) {
            gen.generateSignals(this, frameTime, step);
        }
    }

    protected void processSignals() {
        Reaction reaction;
        Signal<?> signal;
        Reaction reaction2;
        while (!(this.signals.isEmpty() || (reaction2 = this.generateReaction(signal = this.signals.poll())) != null && this.setReaction(reaction2))) {
        }
        if (this.isIdle() && (reaction = this.generateReaction(Signal.IDLE)) != null) {
            this.setReaction(reaction);
        }
    }

    protected void expireShortTermMemory(double time, double step) {
        for (ShortTermMemory mem : (ShortTermMemory[])this.memoryArray.getArray()) {
            mem.update(time, step);
        }
    }

    public double getBrainTime() {
        return this.brainTime;
    }

    public void update(long frameTime, double step) {
        this.lastFrameTime = frameTime;
        this.brainTime += step;
        this.expireShortTermMemory(this.brainTime, step);
        this.generateSignals(frameTime, step);
        this.processSignals();
        if (this.currentBehavior == null) {
            this.setCurrentBehavior(null);
        }
        if (!this.currentBehavior.update(frameTime, step)) {
            this.setCurrentBehavior(null);
        }
        String s = String.format("H:%.02f L:%.02f", this.getProperty("hunger", 0.0), this.getProperty("lonely", 0.0));
        this.setDebugText(this.behaviorName + ":" + this.agent.getDefaultAction() + ":" + s);
    }
}

