/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.util;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnIndex<V> {
    static Logger log = LoggerFactory.getLogger(AbstractColumnIndex.class);
    private ColumnId centerColumn;
    private int radius;
    private int size;
    private ColumnId[][] neighbors;
    private Map<ColumnId, V> index = new HashMap<ColumnId, V>();

    protected AbstractColumnIndex(int radius) {
        this.radius = radius;
        this.size = radius * 2 + 1;
        this.neighbors = new ColumnId[this.size][this.size];
    }

    public void setCenterColumnId(ColumnId centerColumn) {
        if (Objects.equals(centerColumn, this.centerColumn)) {
            return;
        }
        this.centerColumn = centerColumn;
        this.updateNeighbors();
    }

    public ColumnId getCenterColumnId() {
        return this.centerColumn;
    }

    public ColumnId getNeighborColumnId(int xOffset, int zOffset) {
        return this.neighbors[xOffset + this.radius][zOffset + this.radius];
    }

    public V getNeighborColumn(int xOffset, int zOffset) {
        return this.index.get(this.getNeighborColumnId(xOffset, zOffset));
    }

    public V getNeighborColumn(ColumnId colId) {
        return this.index.get(colId);
    }

    public Set<ColumnId> getColumnIds() {
        return this.index.keySet();
    }

    public Collection<V> getColumns() {
        return this.index.values();
    }

    protected void updateNeighbors() {
        HashSet<ColumnId> toRemove = new HashSet<ColumnId>(this.index.keySet());
        Vec3i center = this.centerColumn.getWorld(null);
        for (int x = -this.radius; x <= this.radius; ++x) {
            for (int z = -this.radius; z <= this.radius; ++z) {
                ColumnId id;
                Vec3i pos = center.add(x * 32, 0, z * 32);
                this.neighbors[x + this.radius][z + this.radius] = id = ColumnId.fromWorld(pos);
                if (toRemove.remove(id)) continue;
                this.index.put(id, this.loadColumn(id));
            }
        }
        for (ColumnId id : toRemove) {
            V val = this.index.remove(id);
            this.releaseColumn(id, val);
        }
    }

    protected abstract V loadColumn(ColumnId var1);

    protected abstract void releaseColumn(ColumnId var1, V var2);
}

