/*
 * Decompiled with CFR 0.152.
 */
package mythruna.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshdShellAdapter
implements Command {
    static Logger log = LoggerFactory.getLogger(SshdShellAdapter.class);
    private static final String STATE_COMMAND = "command";
    private static final String STATE_ANSI_PREFIX = "ansi-prefix";
    private static final String STATE_ANSI_CODE = "ansi-code";
    private static final String STATE_SWALLOW1 = "swallow1";
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char ESCAPE = '\u001b';
    private static final char[] CR_LEFT = new char[]{'\u001b', '[', 'D'};
    private static final char[] CR_RIGHT = new char[]{'\u001b', '[', 'C'};
    private static final char[] ERASE_TO_EOL = new char[]{'\u001b', '[', 'K'};
    private InputStream in;
    private OutputStream rawOut;
    private PrintWriter printer;
    private OutputStream err;
    private ExitCallback sshdExitCallback;
    private CommandThread thread;
    private ServerSession session;
    private Environment environment;
    private StringBuilder command = new StringBuilder();
    private int carat = 0;
    private Map<String, State> states = new HashMap<String, State>();
    private State defaultState;
    private State currentState;
    private Consumer<String> commandProcessor;
    private Consumer<SshdShellAdapter> closeCallback;
    private boolean commandRunning = false;

    public SshdShellAdapter(Consumer<String> commandProcessor, Consumer<SshdShellAdapter> closeCallback) {
        this.commandProcessor = commandProcessor;
        this.closeCallback = closeCallback;
        this.currentState = this.defaultState = new CommandState();
        this.states.put(STATE_COMMAND, this.defaultState);
        this.states.put(STATE_ANSI_PREFIX, new AnsiPrefixState(STATE_COMMAND, STATE_ANSI_CODE));
        this.states.put(STATE_ANSI_CODE, new AnsiCodeState(STATE_COMMAND, STATE_SWALLOW1));
        this.states.put(STATE_SWALLOW1, new SwallowState(this, STATE_COMMAND));
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.rawOut = out;
        this.printer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(ExitCallback sshdExitCallback) {
        this.sshdExitCallback = sshdExitCallback;
    }

    public void start(ChannelSession channel, Environment env) {
        this.session = channel.getServerSession();
        this.environment = env;
        this.thread = new CommandThread();
        this.thread.start();
        this.reprompt();
    }

    public void println(String s) {
        this.printer.println("\r" + s);
        this.reprompt();
    }

    protected void reprompt() {
        if (this.commandRunning) {
            return;
        }
        this.printer.print(">");
        if (this.command.length() > 0) {
            this.printer.print(this.command);
            for (int i = this.carat; i < this.command.length(); ++i) {
                this.printer.print(CR_LEFT);
            }
        }
        this.printer.flush();
    }

    protected void execute(String command) {
        log.info("command:" + command);
        if (command.trim().length() == 0) {
            return;
        }
        if ("exit".equals(command)) {
            log.info("exiting");
            this.printer.println("Exiting.");
            this.thread.exit();
            return;
        }
        this.commandRunning = true;
        try {
            this.commandProcessor.accept(command);
        }
        catch (Exception e) {
            log.error("Error running:" + command, (Throwable)e);
            this.printer.println(String.valueOf(e));
        }
        finally {
            this.commandRunning = false;
        }
    }

    public void destroy(ChannelSession channel) {
        log.info("destroy(" + channel + ")");
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected void left() {
        if (this.carat <= 0) {
            return;
        }
        --this.carat;
        this.printer.print(CR_LEFT);
    }

    protected void right() {
        if (this.carat >= this.command.length()) {
            return;
        }
        ++this.carat;
        this.printer.print(CR_RIGHT);
    }

    protected void home() {
        while (this.carat > 0) {
            this.printer.print(CR_LEFT);
            --this.carat;
        }
    }

    protected void end() {
        while (this.carat < this.command.length()) {
            this.printer.print(CR_RIGHT);
            ++this.carat;
        }
    }

    protected void insert(int c) {
        this.command.insert(this.carat++, (char)c);
        this.printer.print((char)c);
        this.reprintFrom(this.carat);
    }

    protected void delete() {
        this.command.deleteCharAt(this.carat);
        this.printer.print(ERASE_TO_EOL);
        this.reprintFrom(this.carat);
    }

    protected void backspace() {
        if (this.carat <= 0) {
            return;
        }
        --this.carat;
        this.command.deleteCharAt(this.carat);
        this.printer.print(CR_LEFT);
        this.printer.print(ERASE_TO_EOL);
        this.reprintFrom(this.carat);
    }

    protected void reprintFrom(int pos) {
        if (pos < this.command.length()) {
            int i;
            int backup = 0;
            for (i = pos; i < this.command.length(); ++i) {
                char n = this.command.charAt(i);
                this.printer.print(n);
                ++backup;
            }
            for (i = 0; i < backup; ++i) {
                this.printer.print(CR_LEFT);
            }
        }
    }

    protected void lineFeed() {
        this.printer.print('\r');
        this.printer.print('\n');
        String cmd = this.command.toString();
        this.command.setLength(0);
        this.carat = 0;
        this.execute(cmd);
        this.reprompt();
    }

    protected void transition(String stateName) {
        State state = this.states.get(stateName);
        this.currentState = state != null ? state : this.defaultState;
    }

    private class CommandState
    extends BaseState {
        public CommandState() {
            super(SshdShellAdapter.this, c -> SshdShellAdapter.this.insert(c));
            this.setHandler(13, c -> SshdShellAdapter.this.lineFeed());
            this.setHandler(27, c -> SshdShellAdapter.this.transition(SshdShellAdapter.STATE_ANSI_PREFIX));
            this.setHandler(127, c -> SshdShellAdapter.this.backspace());
        }
    }

    private static interface State
    extends IntConsumer {
    }

    private class AnsiPrefixState
    extends BaseState {
        public AnsiPrefixState(String returnState, String nextState) {
            super(SshdShellAdapter.this, c -> {
                log.info("Unknown prefix:" + c);
                SshdShellAdapter.this.transition(returnState);
                mythruna$server$SshdShellAdapter$this.printer.print('\u001b');
                mythruna$server$SshdShellAdapter$this.printer.print((char)c);
            });
            this.setHandler(91, c -> SshdShellAdapter.this.transition(nextState));
        }
    }

    private class AnsiCodeState
    extends BaseState {
        public AnsiCodeState(String returnState, String swallowState) {
            super(SshdShellAdapter.this, c -> {
                log.info("Unknown ANSI code:" + c);
                SshdShellAdapter.this.transition(returnState);
            });
            this.setHandler(68, c -> {
                SshdShellAdapter.this.left();
                SshdShellAdapter.this.transition(returnState);
            });
            this.setHandler(67, c -> {
                SshdShellAdapter.this.right();
                SshdShellAdapter.this.transition(returnState);
            });
            this.setHandler(49, c -> {
                SshdShellAdapter.this.home();
                SshdShellAdapter.this.transition(swallowState);
            });
            this.setHandler(52, c -> {
                SshdShellAdapter.this.end();
                SshdShellAdapter.this.transition(swallowState);
            });
            this.setHandler(51, c -> {
                SshdShellAdapter.this.delete();
                SshdShellAdapter.this.transition(swallowState);
            });
        }
    }

    private class SwallowState
    extends BaseState {
        public SwallowState(SshdShellAdapter sshdShellAdapter, String nextState) {
            super(sshdShellAdapter, (int c) -> sshdShellAdapter.transition(nextState));
        }
    }

    private class CommandThread
    extends Thread {
        private AtomicBoolean go = new AtomicBoolean(true);

        public void exit() {
            this.go.set(false);
        }

        @Override
        public void run() {
            try {
                int c;
                while (this.go.get() && (c = SshdShellAdapter.this.in.read()) >= 0) {
                    SshdShellAdapter.this.currentState.accept(c);
                    SshdShellAdapter.this.printer.flush();
                }
            }
            catch (IOException e) {
                if (this.go.get()) {
                    log.error("error reading/writing", (Throwable)e);
                }
            }
            finally {
                log.info("thread exiting");
                if (SshdShellAdapter.this.sshdExitCallback != null) {
                    SshdShellAdapter.this.sshdExitCallback.onExit(0);
                }
                if (SshdShellAdapter.this.closeCallback != null) {
                    SshdShellAdapter.this.closeCallback.accept(SshdShellAdapter.this);
                }
            }
        }
    }

    private class BaseState
    implements State {
        private Map<Integer, IntConsumer> handlers = new HashMap<Integer, IntConsumer>();
        private IntConsumer defaultHandler;

        protected BaseState(SshdShellAdapter sshdShellAdapter, IntConsumer defaultHandler) {
            this.defaultHandler = defaultHandler;
        }

        protected void setHandler(int c, IntConsumer handler) {
            this.handlers.put(c, handler);
        }

        @Override
        public void accept(int c) {
            IntConsumer handler = this.handlers.get(c);
            if (handler != null) {
                handler.accept(c);
            } else {
                this.defaultHandler.accept(c);
            }
        }
    }
}

