
//#import "MatDefs/wind.glsllib"

uniform mat4 g_WorldViewProjectionMatrix;
uniform mat4 g_WorldMatrix;
uniform mat3 g_NormalMatrix;
uniform float g_Time;


#ifndef TIME_BIAS
#define TIME_BIAS 0.0
#endif


//uniform vec2 m_ScreenSpace;
uniform sampler2D m_AtlasMap;
uniform sampler2D m_WindNoise;
uniform float m_Scale;
uniform float m_ZOffset;

attribute vec3 inPosition;
attribute vec3 inTexCoord;

varying vec2 texCoord;
varying float cell1;
varying float cell2;
varying float cell3;
varying float offset1;
varying float offset2;
varying float offset3;


void main(){
    vec2 m_ScreenSpace = vec2(1.0);


    vec3 rawTexCoord = inTexCoord;
    vec4 modelSpacePos = vec4(inPosition, 1.0);

    float timeOffset = modelSpacePos.x * 0.1 + modelSpacePos.z * 3.7 + modelSpacePos.y * 7.1;

    #ifdef BILLBOARD
    // Calculate where we'd like the vertex to be for
    // a y-axis-locked billboard.  We'll mix this with
    // an unlocked version based on view vector.
    vec4 top = modelSpacePos;
    top.y += rawTexCoord.y * m_Scale;
    float scale = length( g_WorldMatrix[0].xyz );

    // old way
    //modelSpacePos.y += rawTexCoord.y * m_Scale;
    //modelSpacePos.x += rawTexCoord.x;

        #ifdef WIND
            float windStrength = 1.0; // rawTexCoord.y * m_Scale * 2.0;
            vec3 wind = tipWind( top.xyz, floor(modelSpacePos.y), vec3(1.0, 0.0, 0.0), windStrength, g_Time, m_WindNoise );
            top.xyz += wind; // * (rawTexCoord.y * m_Scale * 4.0);

            //float windSpeed = dot( wind, wind );
            float windSpeed = simpleNoise( m_WindNoise, modelSpacePos.x, modelSpacePos.z, g_Time * 0.5 );
            windSpeed = windSpeed * windSpeed;
        #else
            float windSpeed = 0.0;
        #endif

    #else
    float windSpeed = 0.0;

    #endif


    /*#ifdef BILLBOARD
    modelSpacePos.y += rawTexCoord.y * m_Scale;
    //modelSpacePos.x += rawTexCoord.x;
    float scale = length( g_WorldMatrix[0].xyz );
    #endif*/

    // Calculate the period based offsets for the different
    // layers.  We do this here partially to avoid time-constant
    // calculations in the .frag and partially to have flySpeed
    // here where we might vary it.
    float flySpeed = FLY_SPEED + windSpeed * 0.001;

    float baseTime = (g_Time+TIME_BIAS+timeOffset) * flySpeed;
    offset1 = mod(baseTime, FLY_LENGTH)/FLY_LENGTH;
    offset2 = mod(baseTime - FLY_LENGTH * 0.333, FLY_LENGTH)/FLY_LENGTH;
    offset3 = mod(baseTime - FLY_LENGTH * 0.666, FLY_LENGTH)/FLY_LENGTH;

    #ifdef CYCLE_CELLS
    cell1 = mod( floor(baseTime), float(ATLAS_CELL_COUNT) );
    cell2 = mod( floor(baseTime + 0.333 + 1.0), float(ATLAS_CELL_COUNT) );
    cell3 = mod( floor(baseTime + 0.666 + 2.0), float(ATLAS_CELL_COUNT) );
    #else
    cell1 = 0.0;
    cell2 = mod(1.0, float(ATLAS_CELL_COUNT));
    cell3 = mod(2.0, float(ATLAS_CELL_COUNT));
    #endif

    #ifdef BILLBOARD
    // Modify the texture coordinate to be 0 to 1 from
    // source data that may be -scale to scale or 0 to scale
    // So even if scale is 0.5 or 2 the below will normalize
    // it to 1.
    texCoord = sign(rawTexCoord.xy);
    texCoord = texCoord * 0.5 + abs(texCoord) * 0.5;
    #else
    texCoord = rawTexCoord.xy;
    #endif

    gl_Position = g_WorldViewProjectionMatrix * modelSpacePos;


    #ifdef BILLBOARD

    // Calculate the position as if this were a non-axis locked
    // billboard
    //gl_Position.x += 0.75 * rawTexCoord.x * m_ScreenSpace.x * m_Scale * scale;
    gl_Position.x += rawTexCoord.x * m_ScreenSpace.x * m_Scale * scale;
    gl_Position.y += rawTexCoord.y * m_ScreenSpace.y * m_Scale * scale * 0.5;

    // Calculate the locked version in view space
    top = g_WorldViewProjectionMatrix * top;
    top.x += rawTexCoord.x * m_ScreenSpace.x * m_Scale * scale;
    //top.x += 0.75 * rawTexCoord.x * m_ScreenSpace.x * m_Scale * scale;

    // Figure out the y-up vector in view space
    vec3 up = vec3( 0.0, 1.0, 0.0 );

    // Note: the NormalMatrix is scale-inverted so if we are in scaled
    // space then the vector won't be "unit" after rotation.
    up = g_NormalMatrix * up;

    // Mix the two values together based on our "upness"
    gl_Position = mix( gl_Position, top, abs(up.y*scale) );

    // And then give it a little extra nudge anyway
    gl_Position.y += texCoord.y * abs(up.z*scale) * m_Scale * scale;

    // Offset by the built in z-space offset (our version of polyoffset)
    gl_Position.z += rawTexCoord.z + m_ZOffset;

    #endif

}
