/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.path;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Vec3i;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathNode
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(PathNode.class);
    private Vec3i location;
    private int type;
    private int width;
    private int depth;
    private int influence;

    public PathNode(Vec3i location, int type, int width, int depth, int influence) {
        this.location = location;
        this.type = type;
        this.width = width;
        this.depth = depth;
        this.influence = influence;
    }

    public PathNode clone() {
        try {
            return (PathNode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("And what are we supposed to do about it?!?", e);
        }
    }

    public Vec3i getLocation() {
        return this.location;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setInfluence(int influence) {
        this.influence = influence;
    }

    public int getInfluence() {
        return this.influence;
    }

    public boolean isSame(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PathNode other = (PathNode)o;
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.depth != other.depth) {
            return false;
        }
        return this.influence == other.influence;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PathNode other = (PathNode)o;
        return Objects.equals(this.location, other.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("location", (Object)this.location).add("type", this.type).add("width", this.width).add("depth", this.depth).add("influence", this.influence).toString();
    }
}

