/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.PanelTweens;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.Tweens;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiControl;
import java.util.ArrayList;
import java.util.List;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundImageState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(BackgroundImageState.class);
    private Label label;
    private List<String> frames = new ArrayList<String>();
    private float fadeInterval = 60.0f;
    private float fadeTime = 0.0f;
    private int currentIndex = 0;
    private String currentFrame;
    private IconComponent lastFrame;

    public BackgroundImageState() {
        this.setEnabled(false);
    }

    protected void testEnabled(boolean f) {
        log.info("testEnabled(" + f + ")");
        super.setEnabled(f);
    }

    public void fadeIn(double time) {
        time = 1.0;
        this.testEnabled(true);
    }

    public void fadeOut(double time) {
        if (this.label == null) {
            return;
        }
        ((AnimationState)this.getState(AnimationState.class)).add(new Tween[]{PanelTweens.fade((Panel)this.label, (Float)Float.valueOf(1.0f), (Float)Float.valueOf(0.0f), (double)time), Tweens.callMethod((Object)((Object)this), (String)"testEnabled", (Object[])new Object[]{false})});
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        log.info("onEnable()");
        GuiState guiState = (GuiState)this.getState(GuiState.class, true);
        this.frames.add("/Interface/night-blur.jpg");
        this.frames.add("/Interface/day-blur.jpg");
        this.label = new Label("");
        this.label.setFontSize(1.0f);
        this.label.setText(null);
        this.label.setLocalTranslation(0.0f, guiState.getGuiSize().y, 0.0f);
        this.label.move(0.0f, 0.0f, -1.0f);
        Node gui = guiState.getGuiRoot();
        gui.attachChild((Spatial)this.label);
        this.currentIndex = 0;
        this.setFrame(this.frames.get(this.currentIndex));
        this.nextFrame();
    }

    protected void onDisable() {
        log.info("onDisable()");
        this.label.removeFromParent();
        this.frames.clear();
        this.currentFrame = null;
        this.lastFrame = null;
        this.label = null;
    }

    public void update(float tpf) {
        this.fadeTime -= tpf;
        if (this.fadeTime < 0.0f) {
            this.nextFrame();
            return;
        }
        float alpha = this.smoothStep(0.0f, this.fadeInterval, this.fadeTime);
        this.lastFrame.setAlpha(alpha);
    }

    protected float smoothStep(float min, float max, float value) {
        if (value < min) {
            return 0.0f;
        }
        if (value > max) {
            return 1.0f;
        }
        float t = (value - min) / (max - min);
        return t * t * (3.0f - 2.0f * t);
    }

    protected void nextFrame() {
        this.currentIndex = (this.currentIndex + 1) % this.frames.size();
        this.setFrame(this.frames.get(this.currentIndex));
    }

    protected void setFrame(String frame) {
        log.info("setFrame(" + frame + ") lastFrame:" + this.lastFrame);
        if (frame == this.currentFrame) {
            log.info("Already have this frame:" + frame);
            return;
        }
        if (this.lastFrame != null) {
            log.info("removing last frame:" + this.lastFrame);
            ((GuiControl)this.label.getControl(GuiControl.class)).removeComponent((GuiComponent)this.lastFrame);
        }
        this.lastFrame = (IconComponent)this.label.getIcon();
        this.currentFrame = frame;
        IconComponent newFrame = new IconComponent(frame);
        newFrame.setVAlignment(VAlignment.Center);
        newFrame.setHAlignment(HAlignment.Center);
        this.label.setIcon((GuiComponent)newFrame);
        log.info("new frame:" + newFrame);
        if (this.lastFrame != null) {
            log.info("adding last frame:" + this.lastFrame);
            ((GuiControl)this.label.getControl(GuiControl.class)).addComponent((GuiComponent)this.lastFrame);
            this.fadeTime = this.fadeInterval;
            this.lastFrame.setAlpha(1.0f);
        }
        for (GuiComponent c : ((GuiControl)this.label.getControl(GuiControl.class)).getComponents()) {
            log.info("  c:" + c);
        }
        log.info("lastFrame:" + this.lastFrame);
    }
}

