/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.mathd.Vec3i;
import mythruna.fabric.ClothingAccumulator;
import mythruna.fabric.FabricUtils;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HatBrimTransform
implements ClothingAccumulator {
    static Logger log = LoggerFactory.getLogger(HatBrimTransform.class);
    private ClothingAccumulator delegate;

    public HatBrimTransform(ClothingAccumulator delegate) {
        this.delegate = delegate;
    }

    public int getSizeX() {
        return this.delegate.getSizeX();
    }

    public int getSizeY() {
        return this.delegate.getSizeY();
    }

    public int getValue(int x, int y, int layer) {
        return this.delegate.getValue(x, y, layer);
    }

    public int getTopValue(int x, int y) {
        return this.delegate.getTopValue(x, y);
    }

    public int getLayer(int x, int y) {
        return this.delegate.getLayer(x, y);
    }

    public int addValue(int x, int y, int value) {
        int result = this.delegate.addValue(x, y, value);
        Vec3i alt = this.getAlternate(x, y);
        log.info("addValue(" + x + ", " + y + ", " + value + ") alt:" + alt);
        if (alt != null) {
            this.delegate.insertValue(alt.x, alt.y, this.getTransform(value));
        }
        return result;
    }

    public int insertValue(int x, int y, int value) {
        int result = this.delegate.insertValue(x, y, value);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.addValue(alt.x, alt.y, this.getTransform(value));
        }
        return result;
    }

    public int removeSwatch(int x, int y) {
        int result = this.delegate.removeSwatch(x, y);
        Vec3i alt = this.getAlternate(x, y);
        log.info("removeSwatch(" + x + ", " + y + ") alt:" + alt);
        if (alt != null) {
            this.delegate.deleteValue(alt.x, alt.y);
        }
        return result;
    }

    public int deleteValue(int x, int y) {
        int result = this.delegate.deleteValue(x, y);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.removeSwatch(alt.x, alt.y);
        }
        return result;
    }

    protected Vec3i getAlternate(int x, int y) {
        if (x >= 12 && x <= 24) {
            if (y >= 9 && y <= 11) {
                int offset = y - 9;
                return new Vec3i(x, 15 - offset, 0);
            }
            if (y >= 13 && y <= 15) {
                int offset = y - 13;
                return new Vec3i(x, 11 - offset, 0);
            }
        }
        if (x >= 20 && x <= 30) {
            if (y <= 2) {
                int offset = y;
                return new Vec3i(x, 6 - offset, 0);
            }
            if (y >= 4 && y <= 6) {
                int offset = y - 4;
                return new Vec3i(x, 2 - offset, 0);
            }
        }
        return null;
    }

    protected int getTransform(int value) {
        int fabric = FabricUtils.toFabric((int)value);
        int shape = FabricUtils.toShape((int)value);
        shape = SwatchShapeIndex.transform((Transform)Transform.ReflectY, (int)shape, (int)1);
        return FabricUtils.toCell((int)shape, (int)fabric);
    }
}

