/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.fractal;

import com.google.common.base.MoreObjects;
import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.Sampler;
import com.simsilica.fractal.SamplerRange;
import com.simsilica.mathd.Vec3d;
import java.util.Arrays;

public class Samplers {
    public static Sampler constant(double value) {
        return new Constant(value);
    }

    public static Sampler dot(Vec3d vec) {
        return new Dot(vec);
    }

    public static Sampler distance(Vec3d pos) {
        return new Distance(pos);
    }

    public static Sampler distance(double x, double y, double z) {
        return Samplers.distance(new Vec3d(x, y, z));
    }

    public static Sampler abs(Sampler sampler) {
        return new Abs(sampler);
    }

    public static Sampler step(double edge, Sampler sampler) {
        return new Step(edge, sampler);
    }

    public static Sampler step(Sampler edge, Sampler sampler) {
        return new ParamStep(edge, sampler);
    }

    public static Sampler smoothStep(double edge1, double edge2, Sampler sampler) {
        return new SmoothStep(edge1, edge2, sampler);
    }

    public static Sampler smoothStep(Sampler edge1, Sampler edge2, Sampler sampler) {
        return new ParamSmoothStep(edge1, edge2, sampler);
    }

    public static Sampler clamp(Sampler sampler, double min, double max) {
        return new Clamp(sampler, min, max);
    }

    public static Sampler clamp(Sampler sampler, Sampler min, Sampler max) {
        return new ParamClamp(sampler, min, max);
    }

    public static Sampler reflect(Sampler sampler, double min, double max) {
        return new Reflect(sampler, min, max);
    }

    public static Sampler reflect(Sampler sampler, Sampler min, Sampler max) {
        return new ParamReflect(sampler, min, max);
    }

    public static Sampler clip(Sampler sampler, double min, double max) {
        return new Clip(sampler, min, max);
    }

    public static Sampler clip(Sampler sampler, Sampler min, Sampler max) {
        return new ParamClip(sampler, min, max);
    }

    public static Sampler modulo(Sampler sampler, double modulo) {
        return new Modulo(sampler, modulo);
    }

    public static Sampler resample(Sampler source, double xScale, double yScale, double zScale) {
        return new Resampler(source, xScale, yScale, zScale);
    }

    public static Sampler resample(Sampler source, Sampler xScale, Sampler yScale, Sampler zScale) {
        return new ParamResampler(source, xScale, yScale, zScale);
    }

    public static Sampler offset(Sampler source, double xOffset, double yOffset, double zOffset) {
        return new Offset(source, xOffset, yOffset, zOffset);
    }

    public static Sampler offset(Sampler source, Sampler xOffset, Sampler yOffset, Sampler zOffset) {
        return new ParamOffset(source, xOffset, yOffset, zOffset);
    }

    public static Sampler scale(Sampler source, double scale) {
        return new Scaler(source, scale);
    }

    public static Sampler scale(Sampler source, Sampler scale) {
        return new Multiply(source, scale);
    }

    public static Sampler mult(Sampler source1, Sampler source2) {
        return new Multiply(source1, source2);
    }

    public static Sampler div(Sampler source1, Sampler source2) {
        return new Divide(source1, source2);
    }

    public static Sampler add(Sampler source1, Sampler source2) {
        return new Add(source1, source2);
    }

    public static Sampler add(Sampler ... sources) {
        return new MultiAdd(sources);
    }

    public static Sampler subtract(Sampler source1, Sampler source2) {
        return new Subtract(source1, source2);
    }

    public static Sampler max(Sampler source1, Sampler source2) {
        return new Max(source1, source2);
    }

    public static Sampler max(Sampler ... sources) {
        return new MultiMax(sources);
    }

    public static Sampler pow(Sampler source, double pow) {
        return new Pow(source, pow);
    }

    public static Sampler pow(Sampler source, Sampler pow) {
        return new ParamPow(source, pow);
    }

    public static Sampler reslope(Sampler source, double pow, double min, double max) {
        return new Reslope(source, pow, min, max);
    }

    public static Sampler reslope(Sampler source, Sampler pow) {
        return new ParamReslope(source, pow);
    }

    public static Sampler sin(Sampler theta) {
        return new SinSampler(theta);
    }

    private static class SinSampler
    extends AbstractSampler {
        private Sampler theta;

        public SinSampler(Sampler theta) {
            super(-1.0, 1.0);
            this.theta = theta;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double value = this.theta.getSample(x, y, z);
            return Math.sin(value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("theta", (Object)this.theta).toString();
        }
    }

    private static class ParamClip
    extends AbstractSampler {
        private Sampler sampler;
        private Sampler min;
        private Sampler max;

        public ParamClip(Sampler sampler, Sampler min, Sampler max) {
            super(Math.min(0.0, min.getRange().getMin()), Math.max(0.0, max.getRange().getMax()));
            this.sampler = sampler;
            this.min = min;
            this.max = max;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double check;
            double val = this.sampler.getSample(x, y, z);
            if (val < (check = this.min.getSample(x, y, z))) {
                return 0.0;
            }
            check = this.max.getSample(x, y, z);
            if (val > check) {
                return 0.0;
            }
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("min", (Object)this.min).add("max", (Object)this.max).toString();
        }
    }

    private static class Clip
    extends AbstractSampler {
        private Sampler sampler;
        private double min;
        private double max;

        public Clip(Sampler sampler, double min, double max) {
            super(Math.min(0.0, min), Math.max(0.0, max));
            this.sampler = sampler;
            this.min = min;
            this.max = max;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double val = this.sampler.getSample(x, y, z);
            if (val < this.min) {
                return 0.0;
            }
            if (val > this.max) {
                return 0.0;
            }
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("min", this.min).add("max", this.max).toString();
        }
    }

    private static class Modulo
    extends AbstractSampler {
        private Sampler sampler;
        private double modulo;

        public Modulo(Sampler sampler, double modulo) {
            super(-modulo, modulo);
            this.sampler = sampler;
            this.modulo = modulo;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double val = this.sampler.getSample(x, y, z) % this.modulo;
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("modulo", this.modulo).toString();
        }
    }

    private static class ParamReflect
    extends AbstractSampler {
        private Sampler sampler;
        private Sampler min;
        private Sampler max;

        public ParamReflect(Sampler sampler, Sampler min, Sampler max) {
            super(min.getRange().getMin(), max.getRange().getMax());
            this.sampler = sampler;
            this.min = min;
            this.max = max;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double val = this.sampler.getSample(x, y, z);
            double minVal = this.min.getSample(x, y, z);
            double maxVal = this.max.getSample(x, y, z);
            double range = maxVal - minVal;
            if (val < minVal) {
                double over = (minVal - val) % range;
                return minVal + over;
            }
            if (val > maxVal) {
                double over = (val - maxVal) % range;
                return maxVal - over;
            }
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("min", (Object)this.min).add("max", (Object)this.max).toString();
        }
    }

    private static class Reflect
    extends AbstractSampler {
        private Sampler sampler;
        private double min;
        private double max;
        private double range;

        public Reflect(Sampler sampler, double min, double max) {
            super(min, max);
            this.sampler = sampler;
            this.min = min;
            this.max = max;
            this.range = max - min;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double val = this.sampler.getSample(x, y, z);
            if (val < this.min) {
                double over = (this.min - val) % this.range;
                return this.min + over;
            }
            if (val > this.max) {
                double over = (val - this.max) % this.range;
                return this.max - over;
            }
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("min", this.min).add("max", this.max).toString();
        }
    }

    private static class ParamClamp
    extends AbstractSampler {
        private Sampler sampler;
        private Sampler min;
        private Sampler max;

        public ParamClamp(Sampler sampler, Sampler min, Sampler max) {
            super(min.getRange().getMin(), max.getRange().getMax());
            this.sampler = sampler;
            this.min = min;
            this.max = max;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double check;
            double val = this.sampler.getSample(x, y, z);
            if (val < (check = this.min.getSample(x, y, z))) {
                return check;
            }
            check = this.max.getSample(x, y, z);
            if (val > check) {
                return check;
            }
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("min", (Object)this.min).add("max", (Object)this.max).toString();
        }
    }

    private static class Clamp
    extends AbstractSampler {
        private Sampler sampler;
        private double min;
        private double max;

        public Clamp(Sampler sampler, double min, double max) {
            super(min, max);
            this.sampler = sampler;
            this.min = min;
            this.max = max;
        }

        @Override
        public double getSample(double x, double y, double z) {
            double val = this.sampler.getSample(x, y, z);
            if (val < this.min) {
                return this.min;
            }
            if (val > this.max) {
                return this.max;
            }
            return val;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("sampler", (Object)this.sampler).add("min", this.min).add("max", this.max).toString();
        }
    }

    private static class MultiMax
    extends AbstractSampler {
        private Sampler[] samplers;

        public MultiMax(Sampler[] samplers) {
            super(SamplerRange.maxRanges(samplers));
            this.samplers = samplers;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double result = Double.NEGATIVE_INFINITY;
            for (Sampler s : this.samplers) {
                result = Math.max(result, s.getSample(x, y, z));
            }
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("samplers", Arrays.asList(this.samplers)).toString();
        }
    }

    private static class Max
    extends AbstractSampler {
        private Sampler source1;
        private Sampler source2;

        public Max(Sampler source1, Sampler source2) {
            super(source1.getRange().max(source2.getRange()));
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return Math.max(this.source1.getSample(x, y, z), this.source2.getSample(x, y, z));
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source1", (Object)this.source1).add("source2", (Object)this.source2).toString();
        }
    }

    private static class ParamReslope
    extends AbstractSampler {
        private Sampler delegate;
        private Sampler pow;

        public ParamReslope(Sampler delegate, Sampler pow) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.pow = pow;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double p;
            double val = this.delegate.getSample(x, y, z);
            double result = Math.pow(val, p = this.pow.getSample(x, y, z));
            if (result > 0.0 && val < 0.0 || result < 0.0 && val > 0.0) {
                return -result;
            }
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("pow", (Object)this.pow).toString();
        }
    }

    private static class Reslope
    extends AbstractSampler {
        private Sampler delegate;
        private double pow;
        private double min;
        private double max;

        public Reslope(Sampler delegate, double pow, double min, double max) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.pow = pow;
            this.min = min;
            this.max = max;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double val = this.delegate.getSample(x, y, z);
            if (val <= this.min) {
                return val;
            }
            if (val >= this.max) {
                return val;
            }
            double range = this.max - this.min;
            double v = (val - this.min) / range;
            v = Math.pow(v, this.pow);
            return this.min + v * range;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("pow", this.pow).add("min", this.min).add("max", this.max).toString();
        }
    }

    private static class ParamPow
    extends AbstractSampler {
        private Sampler delegate;
        private Sampler pow;

        public ParamPow(Sampler delegate, Sampler pow) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.pow = pow;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double val = this.delegate.getSample(x, y, z);
            double p = this.pow.getSample(x, y, z);
            return Math.pow(val, p);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("pow", (Object)this.pow).toString();
        }
    }

    private static class Pow
    extends AbstractSampler {
        private Sampler delegate;
        private double pow;

        public Pow(Sampler delegate, double pow) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.pow = pow;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double val = this.delegate.getSample(x, y, z);
            return Math.pow(val, this.pow);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("pow", this.pow).toString();
        }
    }

    private static class Subtract
    extends AbstractSampler {
        private Sampler source1;
        private Sampler source2;

        public Subtract(Sampler source1, Sampler source2) {
            super(source1.getRange().subtract(source2.getRange()));
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.source1.getSample(x, y, z) - this.source2.getSample(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source1", (Object)this.source1).add("source2", (Object)this.source2).toString();
        }
    }

    private static class MultiAdd
    extends AbstractSampler {
        private Sampler[] samplers;

        public MultiAdd(Sampler[] samplers) {
            super(SamplerRange.addRanges(samplers));
            this.samplers = samplers;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double result = 0.0;
            for (Sampler s : this.samplers) {
                result += s.getSample(x, y, z);
            }
            return result;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("samplers", Arrays.asList(this.samplers)).toString();
        }
    }

    private static class Add
    extends AbstractSampler {
        private Sampler source1;
        private Sampler source2;

        public Add(Sampler source1, Sampler source2) {
            super(source1.getRange().add(source2.getRange()));
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.source1.getSample(x, y, z) + this.source2.getSample(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source1", (Object)this.source1).add("source2", (Object)this.source2).toString();
        }
    }

    private static class Divide
    extends AbstractSampler {
        private Sampler source1;
        private Sampler source2;

        public Divide(Sampler source1, Sampler source2) {
            super(source1.getRange().div(source2.getRange()));
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double v = this.source1.getSample(x, y, z);
            if (v == 0.0) {
                return 0.0;
            }
            return v / this.source2.getSample(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source1", (Object)this.source1).add("source2", (Object)this.source2).toString();
        }
    }

    private static class Multiply
    extends AbstractSampler {
        private Sampler source1;
        private Sampler source2;

        public Multiply(Sampler source1, Sampler source2) {
            super(source1.getRange().mult(source2.getRange()));
            this.source1 = source1;
            this.source2 = source2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double v = this.source1.getSample(x, y, z);
            if (v == 0.0) {
                return 0.0;
            }
            return v * this.source2.getSample(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source1", (Object)this.source1).add("source2", (Object)this.source2).toString();
        }
    }

    private static class Scaler
    extends AbstractSampler {
        private Sampler source;
        private double scale;

        public Scaler(Sampler source, double scale) {
            super(source.getRange().mult(scale));
            this.source = source;
            this.scale = scale;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.scale * this.source.getSample(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("scale", this.scale).toString();
        }
    }

    private static class ParamOffset
    extends AbstractSampler {
        private Sampler source;
        private Sampler xOffset;
        private Sampler yOffset;
        private Sampler zOffset;

        public ParamOffset(Sampler source, Sampler xOffset, Sampler yOffset, Sampler zOffset) {
            super(source.getRange());
            this.source = source;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double xo = this.xOffset.getSample(x, y, z);
            double yo = this.yOffset.getSample(x, y, z);
            double zo = this.zOffset.getSample(x, y, z);
            return this.source.getSample(x + xo, y + yo, z + zo);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("xOffset", (Object)this.xOffset).add("yOffset", (Object)this.yOffset).add("zOffset", (Object)this.zOffset).toString();
        }
    }

    private static class Offset
    extends AbstractSampler {
        private Sampler source;
        private double xOffset;
        private double yOffset;
        private double zOffset;

        public Offset(Sampler source, double xOffset, double yOffset, double zOffset) {
            super(source.getRange());
            this.source = source;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.zOffset = zOffset;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.source.getSample(x + this.xOffset, y + this.yOffset, z + this.zOffset);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("xOffset", this.xOffset).add("yOffset", this.yOffset).add("zOffset", this.zOffset).toString();
        }
    }

    private static class ParamResampler
    extends AbstractSampler {
        private Sampler source;
        private Sampler xScale;
        private Sampler yScale;
        private Sampler zScale;

        public ParamResampler(Sampler source, Sampler xScale, Sampler yScale, Sampler zScale) {
            super(source.getRange());
            this.source = source;
            this.xScale = xScale;
            this.yScale = yScale;
            this.zScale = zScale;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double xs = this.xScale.getSample(x, y, z);
            double ys = this.yScale.getSample(x, y, z);
            double zs = this.zScale.getSample(x, y, z);
            return this.source.getSample(x * xs, y * ys, z * zs);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("xScale", (Object)this.xScale).add("yScale", (Object)this.yScale).add("zScale", (Object)this.zScale).toString();
        }
    }

    private static class Resampler
    extends AbstractSampler {
        private Sampler source;
        private double xScale;
        private double yScale;
        private double zScale;

        public Resampler(Sampler source, double xScale, double yScale, double zScale) {
            super(source.getRange());
            this.source = source;
            this.xScale = xScale;
            this.yScale = yScale;
            this.zScale = zScale;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.source.getSample(x * this.xScale, y * this.yScale, z * this.zScale);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("source", (Object)this.source).add("xScale", this.xScale).add("yScale", this.yScale).add("zScale", this.zScale).toString();
        }
    }

    private static class ParamSmoothStep
    extends AbstractSampler {
        private Sampler delegate;
        private Sampler edge1;
        private Sampler edge2;

        public ParamSmoothStep(Sampler edge1, Sampler edge2, Sampler delegate) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.edge1 = edge1;
            this.edge2 = edge2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double e1;
            double val = this.delegate.getSample(x, y, z);
            if (val < (e1 = this.edge1.getSample(x, y, z))) {
                return e1;
            }
            double e2 = this.edge2.getSample(x, y, z);
            if ((val = (val - e1) / (e2 - e1)) < 0.0) {
                val = 0.0;
            } else if (val > 1.0) {
                val = 1.0;
            }
            return val * val * (3.0 - 2.0 * val);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("edge1", (Object)this.edge1).add("edge2", (Object)this.edge2).toString();
        }
    }

    private static class SmoothStep
    extends AbstractSampler {
        private Sampler delegate;
        private double edge1;
        private double edge2;

        public SmoothStep(double edge1, double edge2, Sampler delegate) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.edge1 = edge1;
            this.edge2 = edge2;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double val = this.delegate.getSample(x, y, z);
            if ((val = (val - this.edge1) / (this.edge2 - this.edge1)) < 0.0) {
                val = 0.0;
            } else if (val > 1.0) {
                val = 1.0;
            }
            return val * val * (3.0 - 2.0 * val);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("edge1", this.edge1).add("edge2", this.edge2).toString();
        }
    }

    private static class ParamStep
    extends AbstractSampler {
        private Sampler delegate;
        private Sampler edge;

        public ParamStep(Sampler edge, Sampler delegate) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.edge = edge;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double e;
            double val = this.delegate.getSample(x, y, z);
            return val < (e = this.edge.getSample(x, y, z)) ? 0.0 : 1.0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("edge", (Object)this.edge).toString();
        }
    }

    private static class Step
    extends AbstractSampler {
        private Sampler delegate;
        private double edge;

        public Step(double edge, Sampler delegate) {
            super(0.0, 1.0);
            this.delegate = delegate;
            this.edge = edge;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            double val = this.delegate.getSample(x, y, z);
            return val < this.edge ? 0.0 : 1.0;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).add("edge", this.edge).toString();
        }
    }

    private static class Abs
    extends AbstractSampler {
        private Sampler delegate;

        public Abs(Sampler delegate) {
            super(0.0, delegate.getRange().getMax());
            this.delegate = delegate;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return Math.abs(this.delegate.getSample(x, y, z));
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("delegate", (Object)this.delegate).toString();
        }
    }

    private static class Distance
    extends AbstractSampler {
        private Vec3d pos;

        public Distance(Vec3d pos) {
            super(SamplerRange.POSITIVE_INFINITY);
            this.pos = pos;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.pos.distance(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("pos", (Object)this.pos).toString();
        }
    }

    private static class Dot
    extends AbstractSampler {
        private Vec3d vec;

        public Dot(Vec3d vec) {
            super(SamplerRange.INFINITY);
            this.vec = vec;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.vec.dot(x, y, z);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("vec", (Object)this.vec).toString();
        }
    }

    private static class Constant
    extends AbstractSampler {
        private double value;
        private SamplerRange range;

        public Constant(double value) {
            super(value, value);
            this.value = value;
        }

        @Override
        public final double getSample(double x, double y, double z) {
            return this.value;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("value", this.value).add("range", (Object)this.range).toString();
        }
    }
}

