/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.base.Function;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Vec3i;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridCellFileFunction
implements Function<Long, File> {
    static Logger log = LoggerFactory.getLogger(GridCellFileFunction.class);
    private File root;
    private Grid grid;
    private int shift;
    private String extension;

    public GridCellFileFunction(File root, Grid grid, int shift, String extension) {
        this.root = root;
        this.grid = grid;
        this.shift = shift;
        if (extension.charAt(0) == '.') {
            extension = extension.substring(1);
        }
        this.extension = extension;
    }

    public File apply(Long id) {
        Vec3i cell = this.grid.idToCell(id.longValue());
        File dir = new File(this.root, (cell.x >> this.shift) + "/" + (cell.z >> this.shift));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, id + "." + this.extension);
    }
}

