/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.morph;

import com.simsilica.mathd.Vec3i;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.tile.TerrainImage;
import com.simsilica.mworld.tile.TerrainImageType;
import com.simsilica.mworld.tile.Tile;
import com.simsilica.mworld.tile.morph.AbstractBoxMorphology;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoxFill
extends AbstractBoxMorphology {
    static Logger log = LoggerFactory.getLogger(BoxFill.class);
    private int blockFill;
    private byte terrainFill;
    private boolean affectTerrain;
    private boolean carve;

    public BoxFill(Vec3i min, Vec3i max, int blockFill, byte terrainFill) {
        this(min, max, blockFill, terrainFill, true, false);
    }

    public BoxFill(Vec3i min, Vec3i max, int blockFill, byte terrainFill, boolean affectTerrain, boolean carve) {
        super(min, max);
        this.blockFill = blockFill;
        this.terrainFill = terrainFill;
        this.affectTerrain = affectTerrain;
        this.carve = carve;
    }

    public int getBlockFill() {
        return this.blockFill;
    }

    public byte getTerrainFill() {
        return this.terrainFill;
    }

    @Override
    public boolean morph(Tile tile, Random rand) {
        if (!this.affectTerrain) {
            return false;
        }
        TerrainImage terrain = tile.get((Object)TerrainImageType.Terrain, TerrainImage.class);
        int size = terrain.getSize();
        int skip = 1024 / size;
        Vec3i tileMin = tile.getTileId().getWorld(null);
        Vec3i tileMax = tileMin.add(1024, 0, 1024);
        int xMin = (Math.max(tileMin.x, this.getMin().x) - tileMin.x) / skip;
        int xMax = (Math.min(tileMax.x, this.getMax().x) - tileMin.x) / skip;
        int zMin = (Math.max(tileMin.z, this.getMin().z) - tileMin.z) / skip;
        int zMax = (Math.min(tileMax.z, this.getMax().z) - tileMin.z) / skip;
        int y = this.carve ? this.getMin().y : this.getMax().y;
        boolean changed = false;
        for (int x = xMin; x < xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                terrain.setElevation(x, z, (short)y);
                terrain.setType(x, z, this.terrainFill);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public boolean morph(ColumnData colData, Tile tile, Random rand) {
        Vec3i colMin = colData.getColumnId().getWorld(null);
        Vec3i colMax = colMin.add(COLUMN_SIZE, colData.getCeiling(), COLUMN_SIZE);
        int xMin = Math.max(colMin.x, this.getMin().x) - colMin.x;
        int xMax = Math.min(colMax.x, this.getMax().x) - colMin.x;
        int yMin = Math.max(colMin.y, this.getMin().y) - colMin.y;
        int yMax = Math.min(colMax.y, this.getMax().y) - colMin.y;
        int zMin = Math.max(colMin.z, this.getMin().z) - colMin.z;
        int zMax = Math.min(colMax.z, this.getMax().z) - colMin.z;
        boolean changed = false;
        for (int y = yMin; y < yMax; ++y) {
            int layer = y / 32;
            int yBase = layer * 32;
            LeafData leaf = colData.getLeafs()[layer];
            int j = y - yBase;
            for (int i = xMin; i < xMax; ++i) {
                for (int k = zMin; k < zMax; ++k) {
                    leaf.setCell(i, j, k, this.blockFill);
                    changed = true;
                }
            }
        }
        return changed;
    }
}

