/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.Direction;
import com.simsilica.mblock.geom.BlockFactory;
import com.simsilica.mblock.geom.BoundaryShape;
import com.simsilica.mblock.geom.BoundaryShapes;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomPartBuffer;
import com.simsilica.mblock.geom.MaterialType;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PineBranchBlockFactory
implements BlockFactory {
    static final long serialVersionUID = 2739965253627467680L;
    static Logger log = LoggerFactory.getLogger(PineBranchBlockFactory.class);
    private static final Vec3d min = new Vec3d(0.25, 0.25, 0.25);
    private static final Vec3d max = new Vec3d(0.75, 0.75, 0.75);
    private static final float TIP = -0.3f;
    private static final float T_OFFSET = 0.3f;
    private static final float BRANCH_OFFSET = 0.04f;
    private static final float NEEDLE_OFFSET = 0.85f;
    private static final float BRANCH_LENGTH = 2.5f;
    private static final float BRANCH_WIDTH = 1.3f;
    private static Vector3f[] baseVerts = new Vector3f[]{new Vector3f(0.0f, 0.04f, 0.0f), new Vector3f(1.3f, -0.85f, 0.0f), new Vector3f(0.0f, 0.0f, 2.5f), new Vector3f(-1.3f, -0.85f, 0.0f), new Vector3f(0.0f, 0.04f, 0.0f), new Vector3f(0.0f, 0.0f, 2.5f), new Vector3f(0.0f, -0.04f, 0.0f), new Vector3f(1.3f, 0.85f, 0.0f), new Vector3f(0.0f, 0.0f, 2.5f), new Vector3f(-1.3f, 0.85f, 0.0f), new Vector3f(0.0f, -0.04f, 0.0f), new Vector3f(0.0f, 0.0f, 2.5f)};
    private static Vector3f[] baseNorms = new Vector3f[]{new Vector3f(0.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(1.0f, -1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 1.0f).normalizeLocal(), new Vector3f(-1.0f, -1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 1.0f).normalizeLocal(), new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal(), new Vector3f(1.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 1.0f).normalizeLocal(), new Vector3f(-1.0f, 1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal(), new Vector3f(0.0f, 1.0f, 1.0f).normalizeLocal()};
    private static float[] texCoords = new float[]{0.5f, 1.0f, 1.3f, 1.0f, 0.5f, -0.3f, -0.3f, 1.0f, 0.5f, 1.0f, 0.5f, -0.3f, 0.5f, 1.0f, 1.3f, 1.0f, 0.5f, -0.3f, -0.3f, 1.0f, 0.5f, 1.0f, 0.5f, -0.3f};
    private static short[] indexes = new short[]{0, 2, 1, 3, 5, 4, 6, 7, 8, 9, 10, 11, 0, 1, 2, 3, 4, 5, 6, 8, 7, 9, 11, 10};
    private MaterialType material;
    private Vector3f offset = new Vector3f(0.0f, 0.0f, -0.8f);
    private float yaw;

    public PineBranchBlockFactory(MaterialType mt, double yaw) {
        this.material = mt;
        this.yaw = (float)yaw;
        Quaternion rotate = new Quaternion().fromAngles(0.0f, this.yaw, 0.0f);
        rotate.multLocal(this.offset);
    }

    public int addGeometryToBuffer(GeomPartBuffer buffer, int i, int j, int k, int xWorld, int yWorld, int zWorld, int sideMask, CellData cells, BlockType type) {
        float xCenter = 0.5f + this.offset.x;
        float zCenter = 0.5f + this.offset.z;
        float yBase = 0.75f + this.offset.y;
        yBase += (float)(buffer.nextRandom() * 0.5 - 0.25);
        float a = this.yaw + (float)(buffer.nextRandom() * 20.0 - 10.0) * ((float)Math.PI / 180);
        float p = (float)(buffer.nextRandom() * 20.0 - 10.0) * ((float)Math.PI / 180);
        Quaternion q = new Quaternion().fromAngles(p, a, 0.0f);
        Vector3f[] verts = new Vector3f[baseVerts.length];
        Vector3f[] norms = new Vector3f[baseNorms.length];
        for (int v = 0; v < verts.length; ++v) {
            verts[v] = q.mult(baseVerts[v]);
            norms[v] = q.mult(baseNorms[v]);
        }
        GeomPart part = new GeomPart(this.material, -1, true);
        part.setCoords(new float[]{verts[0].x + xCenter, verts[0].y + yBase, verts[0].z + zCenter, verts[1].x + xCenter, verts[1].y + yBase, verts[1].z + zCenter, verts[2].x + xCenter, verts[2].y + yBase, verts[2].z + zCenter, verts[3].x + xCenter, verts[3].y + yBase, verts[3].z + zCenter, verts[4].x + xCenter, verts[4].y + yBase, verts[4].z + zCenter, verts[5].x + xCenter, verts[5].y + yBase, verts[5].z + zCenter, verts[6].x + xCenter, verts[6].y + yBase, verts[6].z + zCenter, verts[7].x + xCenter, verts[7].y + yBase, verts[7].z + zCenter, verts[8].x + xCenter, verts[8].y + yBase, verts[8].z + zCenter, verts[9].x + xCenter, verts[9].y + yBase, verts[9].z + zCenter, verts[10].x + xCenter, verts[10].y + yBase, verts[10].z + zCenter, verts[11].x + xCenter, verts[11].y + yBase, verts[11].z + zCenter});
        part.setNormals(new float[]{norms[0].x, norms[0].y, norms[0].z, norms[1].x, norms[1].y, norms[1].z, norms[2].x, norms[2].y, norms[2].z, norms[3].x, norms[3].y, norms[3].z, norms[4].x, norms[4].y, norms[4].z, norms[5].x, norms[5].y, norms[5].z, norms[6].x, norms[6].y, norms[6].z, norms[7].x, norms[7].y, norms[7].z, norms[8].x, norms[8].y, norms[8].z, norms[9].x, norms[9].y, norms[9].z, norms[10].x, norms[10].y, norms[10].z, norms[11].x, norms[11].y, norms[11].z});
        part.setTexCoords(texCoords);
        part.setIndexes(indexes);
        buffer.addPart(i, j, k, part);
        return 1;
    }

    public BoundaryShape getShape(Direction dir) {
        return BoundaryShapes.NULL_SHAPE;
    }

    public boolean isSolid(Direction dir) {
        return false;
    }

    public boolean isSolid() {
        return false;
    }

    public double getTransparency(Direction dir) {
        return 0.75;
    }

    public boolean isTransparent() {
        return true;
    }

    public double getVolume() {
        double x = this.getMax().x - this.getMin().x;
        double y = this.getMax().y - this.getMin().y;
        double z = this.getMax().z - this.getMin().z;
        return x * y * z;
    }

    public Vec3d getMin() {
        return min;
    }

    public Vec3d getMax() {
        return max;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        PineBranchBlockFactory other = (PineBranchBlockFactory)o;
        if (other.yaw != this.yaw) {
            return false;
        }
        if (!Objects.equals(other.material, this.material)) {
            return false;
        }
        return Objects.equals(other.offset, this.offset);
    }

    public int hashCode() {
        return Objects.hash(this.material, this.offset, Float.valueOf(this.yaw));
    }

    public BlockFactory rotate(int dirDelta) {
        double newYaw = this.yaw + (float)dirDelta * -1.5707964f;
        return new PineBranchBlockFactory(this.material, newYaw %= Math.PI * 2);
    }
}

