/*
 * Decompiled with CFR 0.152.
 */
package mythruna.post;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.post.Filter;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.texture.Texture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalBlindnessFilter
extends Filter {
    static Logger log = LoggerFactory.getLogger(PortalBlindnessFilter.class);
    private ColorRGBA cloudColor = ColorRGBA.White.clone();
    private ColorRGBA backgroundColor = ColorRGBA.Black.clone();
    private float fadeDistance = 4.0f;
    private float fadeMinimum = 0.1f;
    private float alpha = 1.0f;

    public PortalBlindnessFilter() {
        super("PortalBlindnessFilter");
    }

    public PortalBlindnessFilter(ColorRGBA cloudColor, ColorRGBA backgroundColor, float fadeDistance) {
        this.cloudColor = cloudColor;
        this.backgroundColor = backgroundColor;
        this.fadeDistance = fadeDistance;
    }

    protected boolean isRequiresDepthTexture() {
        return true;
    }

    protected void initFilter(AssetManager manager, RenderManager renderManager, ViewPort vp, int w, int h) {
        this.material = new Material(manager, "MatDefs/PortalBlindness.j3md");
        this.material.setColor("CloudColor", this.cloudColor);
        this.material.setColor("BackgroundColor", this.backgroundColor);
        this.material.setFloat("FadeDistance", this.fadeDistance);
        this.material.setFloat("FadeMinimum", this.fadeMinimum);
        this.material.setFloat("Alpha", this.alpha);
        Texture texture = manager.loadTexture("Textures/noise-x3-512.png");
        texture.setWrap(Texture.WrapMode.Repeat);
        this.material.setTexture("NoiseMap", texture);
    }

    protected Material getMaterial() {
        return this.material;
    }

    public void setFadeDistance(float fadeDistance) {
        if (this.material != null) {
            this.material.setFloat("FadeDistance", fadeDistance);
        }
        this.fadeDistance = fadeDistance;
    }

    public float getFadeDistance() {
        return this.fadeDistance;
    }

    public void setFadeMinimum(float fadeMinimum) {
        if (this.material != null) {
            this.material.setFloat("FadeMinimum", fadeMinimum);
        }
        this.fadeMinimum = fadeMinimum;
    }

    public float getFadeMinimum() {
        return this.fadeMinimum;
    }

    public void setAlpha(float alpha) {
        if (this.material != null) {
            this.material.setFloat("Alpha", alpha);
        }
        this.alpha = alpha;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public ColorRGBA getCloudColor() {
        return this.cloudColor;
    }

    public ColorRGBA getBackgroundColor() {
        return this.backgroundColor;
    }
}

