/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.anim.util;

import com.jme3.anim.AnimClip;
import com.jme3.anim.AnimComposer;
import com.jme3.anim.Armature;
import com.jme3.anim.Joint;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.TransformTrack;
import com.jme3.animation.AnimControl;
import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.animation.Track;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnimMigrationUtils {
    private static final AnimControlVisitor animControlVisitor = new AnimControlVisitor();
    private static final SkeletonControlVisitor skeletonControlVisitor = new SkeletonControlVisitor();

    private AnimMigrationUtils() {
    }

    public static Spatial migrate(Spatial source) {
        HashMap<Skeleton, Armature> skeletonArmatureMap = new HashMap<Skeleton, Armature>();
        animControlVisitor.setMappings(skeletonArmatureMap);
        source.depthFirstTraversal(animControlVisitor);
        skeletonControlVisitor.setMappings(skeletonArmatureMap);
        source.depthFirstTraversal(skeletonControlVisitor);
        return source;
    }

    public static void padJointTracks(List<TransformTrack> tracks, Joint staticJoint) {
        Joint j = staticJoint;
        if (j != null) {
            float[] times = new float[]{0.0f};
            Vector3f[] translations = new Vector3f[]{j.getLocalTranslation()};
            Quaternion[] rotations = new Quaternion[]{j.getLocalRotation()};
            Vector3f[] scales = new Vector3f[]{j.getLocalScale()};
            TransformTrack track = new TransformTrack(j, times, translations, rotations, scales);
            tracks.add(track);
        }
    }

    public static TransformTrack fromBoneTrack(BoneTrack boneTrack, Bone bone, Joint joint) {
        float[] times = new float[boneTrack.getTimes().length];
        int length = times.length;
        System.arraycopy(boneTrack.getTimes(), 0, times, 0, length);
        Vector3f[] translations = new Vector3f[length];
        if (boneTrack.getTranslations() != null) {
            for (int i = 0; i < boneTrack.getTranslations().length; ++i) {
                Vector3f oldTrans = boneTrack.getTranslations()[i];
                Vector3f newTrans = new Vector3f();
                newTrans.set(bone.getBindPosition()).addLocal(oldTrans);
                translations[i] = newTrans;
            }
        }
        Quaternion[] rotations = new Quaternion[length];
        if (boneTrack.getRotations() != null) {
            for (int i = 0; i < boneTrack.getRotations().length; ++i) {
                Quaternion oldRot = boneTrack.getRotations()[i];
                Quaternion newRot = new Quaternion();
                newRot.set(bone.getBindRotation()).multLocal(oldRot);
                rotations[i] = newRot;
            }
        }
        Vector3f[] scales = new Vector3f[length];
        if (boneTrack.getScales() != null) {
            for (int i = 0; i < boneTrack.getScales().length; ++i) {
                Vector3f oldScale = boneTrack.getScales()[i];
                Vector3f newScale = new Vector3f();
                newScale.set(bone.getBindScale()).multLocal(oldScale);
                scales[i] = newScale;
            }
        }
        TransformTrack t = new TransformTrack(joint, times, translations, rotations, scales);
        return t;
    }

    private static Joint fromBone(Bone b) {
        Joint j = new Joint(b.getName());
        j.setLocalTranslation(b.getBindPosition());
        j.setLocalRotation(b.getBindRotation());
        j.setLocalScale(b.getBindScale());
        return j;
    }

    private static class AnimControlVisitor
    implements SceneGraphVisitor {
        Map<Skeleton, Armature> skeletonArmatureMap;

        private AnimControlVisitor() {
        }

        @Override
        public void visit(Spatial spatial) {
            AnimControl control = spatial.getControl(AnimControl.class);
            if (control != null) {
                AnimComposer composer = new AnimComposer();
                Skeleton skeleton = control.getSkeleton();
                if (skeleton == null) {
                    return;
                }
                Joint[] joints = new Joint[skeleton.getBoneCount()];
                for (int i = 0; i < skeleton.getBoneCount(); ++i) {
                    Bone b = skeleton.getBone(i);
                    Joint j = joints[i];
                    if (j == null) {
                        joints[i] = j = AnimMigrationUtils.fromBone(b);
                    }
                    for (Bone bone : b.getChildren()) {
                        int index = skeleton.getBoneIndex(bone);
                        Joint joint = joints[index];
                        if (joint == null) {
                            joint = AnimMigrationUtils.fromBone(bone);
                        }
                        j.addChild(joint);
                        joints[index] = joint;
                    }
                }
                Armature armature = new Armature(joints);
                armature.saveBindPose();
                this.skeletonArmatureMap.put(skeleton, armature);
                ArrayList<TransformTrack> tracks = new ArrayList<TransformTrack>();
                for (String animName : control.getAnimationNames()) {
                    tracks.clear();
                    Animation anim = control.getAnim(animName);
                    AnimClip clip = new AnimClip(animName);
                    Joint[] staticJoints = new Joint[joints.length];
                    System.arraycopy(joints, 0, staticJoints, 0, joints.length);
                    for (Track track : anim.getTracks()) {
                        if (!(track instanceof BoneTrack)) continue;
                        BoneTrack boneTrack = (BoneTrack)track;
                        int index = boneTrack.getTargetBoneIndex();
                        Bone bone = skeleton.getBone(index);
                        Joint joint = joints[index];
                        TransformTrack jointTrack = AnimMigrationUtils.fromBoneTrack(boneTrack, bone, joint);
                        tracks.add(jointTrack);
                        staticJoints[index] = null;
                    }
                    for (int i = 0; i < staticJoints.length; ++i) {
                        AnimMigrationUtils.padJointTracks(tracks, staticJoints[i]);
                    }
                    clip.setTracks(tracks.toArray(new TransformTrack[tracks.size()]));
                    composer.addAnimClip(clip);
                }
                spatial.removeControl(control);
                spatial.addControl(composer);
            }
        }

        public void setMappings(Map<Skeleton, Armature> skeletonArmatureMap) {
            this.skeletonArmatureMap = skeletonArmatureMap;
        }
    }

    private static class SkeletonControlVisitor
    implements SceneGraphVisitor {
        Map<Skeleton, Armature> skeletonArmatureMap;

        private SkeletonControlVisitor() {
        }

        @Override
        public void visit(Spatial spatial) {
            SkeletonControl control = spatial.getControl(SkeletonControl.class);
            if (control != null) {
                Armature armature = this.skeletonArmatureMap.get(control.getSkeleton());
                SkinningControl skinningControl = new SkinningControl(armature);
                HashMap<String, List<Spatial>> attachedSpatials = new HashMap<String, List<Spatial>>();
                for (int i = 0; i < control.getSkeleton().getBoneCount(); ++i) {
                    Bone b = control.getSkeleton().getBone(i);
                    Node n = control.getAttachmentsNode(b.getName());
                    n.removeFromParent();
                    if (n.getChildren().isEmpty()) continue;
                    attachedSpatials.put(b.getName(), n.getChildren());
                }
                spatial.removeControl(control);
                spatial.addControl(skinningControl);
                for (String name : attachedSpatials.keySet()) {
                    List spatials = (List)attachedSpatials.get(name);
                    for (Spatial child : spatials) {
                        skinningControl.getAttachmentsNode(name).attachChild(child);
                    }
                }
            }
        }

        public void setMappings(Map<Skeleton, Armature> skeletonArmatureMap) {
            this.skeletonArmatureMap = skeletonArmatureMap;
        }
    }
}

