/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class Dome
extends Mesh {
    private int planes;
    private int radialSamples;
    private float radius;
    private Vector3f center;
    private boolean insideView = true;

    protected Dome() {
    }

    public Dome(int planes, int radialSamples, float radius) {
        this(new Vector3f(0.0f, 0.0f, 0.0f), planes, radialSamples, radius);
    }

    public Dome(Vector3f center, int planes, int radialSamples, float radius) {
        this.updateGeometry(center, planes, radialSamples, radius, true);
    }

    public Dome(Vector3f center, int planes, int radialSamples, float radius, boolean insideView) {
        this.updateGeometry(center, planes, radialSamples, radius, insideView);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public int getPlanes() {
        return this.planes;
    }

    public int getRadialSamples() {
        return this.radialSamples;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isInsideView() {
        return this.insideView;
    }

    public void updateGeometry(Vector3f center, int planes, int radialSamples, float radius, boolean insideView) {
        this.insideView = insideView;
        this.center = center != null ? center : new Vector3f(0.0f, 0.0f, 0.0f);
        this.planes = planes;
        this.radialSamples = radialSamples;
        this.radius = radius;
        int vertCount = (planes - 1) * (radialSamples + 1) + 1;
        FloatBuffer vb = BufferUtils.createVector3Buffer(vertCount);
        FloatBuffer nb = BufferUtils.createVector3Buffer(vertCount);
        FloatBuffer tb = BufferUtils.createVector2Buffer(vertCount);
        this.setBuffer(VertexBuffer.Type.Position, 3, vb);
        this.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        this.setBuffer(VertexBuffer.Type.TexCoord, 2, tb);
        float fInvRS = 1.0f / (float)radialSamples;
        float fYFactor = 1.0f / (float)(planes - 1);
        float[] afSin = new float[radialSamples];
        float[] afCos = new float[radialSamples];
        for (int iR = 0; iR < radialSamples; ++iR) {
            float fAngle = (float)Math.PI * 2 * fInvRS * (float)iR;
            afCos[iR] = FastMath.cos(fAngle);
            afSin[iR] = FastMath.sin(fAngle);
        }
        TempVars vars = TempVars.get();
        Vector3f tempVc = vars.vect3;
        Vector3f tempVb = vars.vect2;
        Vector3f tempVa = vars.vect1;
        int i = 0;
        int iY = 0;
        while (iY < planes - 1) {
            float fYFraction = fYFactor * (float)iY;
            float fY = radius * fYFraction;
            Vector3f kSliceCenter = tempVb.set(center);
            kSliceCenter.y += fY;
            float fSliceRadius = FastMath.sqrt(FastMath.abs(radius * radius - fY * fY));
            int iSave = i;
            int iR = 0;
            while (iR < radialSamples) {
                float fRadialFraction = (float)iR * fInvRS;
                Vector3f kRadial = tempVc.set(afCos[iR], 0.0f, afSin[iR]);
                kRadial.mult(fSliceRadius, tempVa);
                vb.put(kSliceCenter.x + tempVa.x).put(kSliceCenter.y + tempVa.y).put(kSliceCenter.z + tempVa.z);
                BufferUtils.populateFromBuffer(tempVa, vb, i);
                Vector3f kNormal = tempVa.subtractLocal(center);
                kNormal.normalizeLocal();
                if (!insideView) {
                    nb.put(kNormal.x).put(kNormal.y).put(kNormal.z);
                } else {
                    nb.put(-kNormal.x).put(-kNormal.y).put(-kNormal.z);
                }
                tb.put(fRadialFraction).put(fYFraction);
                ++iR;
                ++i;
            }
            BufferUtils.copyInternalVector3(vb, iSave, i);
            BufferUtils.copyInternalVector3(nb, iSave, i);
            tb.put(1.0f).put(fYFraction);
            ++iY;
            ++i;
        }
        vars.release();
        vb.put(this.center.x).put(this.center.y + radius).put(this.center.z);
        nb.put(0.0f).put(insideView ? -1.0f : 1.0f).put(0.0f);
        tb.put(0.5f).put(1.0f);
        int triCount = (planes - 2) * radialSamples * 2 + radialSamples;
        ShortBuffer ib = BufferUtils.createShortBuffer(3 * triCount);
        this.setBuffer(VertexBuffer.Type.Index, 3, ib);
        int index = 0;
        for (int plane = 1; plane < planes - 1; ++plane) {
            int bottomPlaneStart = (plane - 1) * (radialSamples + 1);
            int topPlaneStart = plane * (radialSamples + 1);
            int sample = 0;
            while (sample < radialSamples) {
                if (insideView) {
                    ib.put((short)(bottomPlaneStart + sample));
                    ib.put((short)(bottomPlaneStart + sample + 1));
                    ib.put((short)(topPlaneStart + sample));
                    ib.put((short)(bottomPlaneStart + sample + 1));
                    ib.put((short)(topPlaneStart + sample + 1));
                    ib.put((short)(topPlaneStart + sample));
                } else {
                    ib.put((short)(bottomPlaneStart + sample));
                    ib.put((short)(topPlaneStart + sample));
                    ib.put((short)(bottomPlaneStart + sample + 1));
                    ib.put((short)(bottomPlaneStart + sample + 1));
                    ib.put((short)(topPlaneStart + sample));
                    ib.put((short)(topPlaneStart + sample + 1));
                }
                ++sample;
                index += 6;
            }
        }
        int bottomPlaneStart = (planes - 2) * (radialSamples + 1);
        int samples = 0;
        while (samples < radialSamples) {
            if (insideView) {
                ib.put((short)(bottomPlaneStart + samples));
                ib.put((short)(bottomPlaneStart + samples + 1));
                ib.put((short)(vertCount - 1));
            } else {
                ib.put((short)(bottomPlaneStart + samples));
                ib.put((short)(vertCount - 1));
                ib.put((short)(bottomPlaneStart + samples + 1));
            }
            ++samples;
            index += 3;
        }
        this.updateBound();
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.planes = capsule.readInt("planes", 0);
        this.radialSamples = capsule.readInt("radialSamples", 0);
        this.radius = capsule.readFloat("radius", 0.0f);
        this.center = (Vector3f)capsule.readSavable("center", Vector3f.ZERO.clone());
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.planes, "planes", 0);
        capsule.write(this.radialSamples, "radialSamples", 0);
        capsule.write(this.radius, "radius", 0.0f);
        capsule.write(this.center, "center", Vector3f.ZERO);
    }
}

