/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.item;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import mythruna.client.ui.item.Item;
import mythruna.item.InventorySize2d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemView
extends Node {
    static Logger log = LoggerFactory.getLogger(ItemView.class);
    public static float labelScale = 0.1f;
    private static boolean testBackground = false;
    private Item item;
    private VersionedReference<Spatial> modelRef;
    private VersionedReference<InventorySize2d> itemSizeRef;
    private VersionedReference<Vec3i> slotRef;
    private VersionedReference<Integer> countRef;
    private VersionedReference<Integer> maxCountRef;
    private Label countLabel;
    private Vec3d bbSize = new Vec3d(1.0, 1.0, 0.0);
    private Quad testQuad;
    private Geometry testGeom;

    public ItemView(Item item) {
        this.item = item;
        if (testBackground) {
            this.testQuad = new Quad(1.0f, 1.0f);
            Geometry geom = this.testGeom = new Geometry("test", (Mesh)this.testQuad);
            geom.move(0.0f, -1.0f, 0.0f);
            geom.setMaterial(GuiGlobals.getInstance().createMaterial(ColorRGBA.Red, false).getMaterial());
            this.attachChild((Spatial)geom);
        }
        this.modelRef = item.createModelRef();
        this.itemSizeRef = item.createItemSizeRef();
        this.slotRef = item.createSlotRef();
        this.countRef = item.createCountRef();
        this.maxCountRef = item.createMaxCountRef();
        this.resetItemSize((InventorySize2d)this.itemSizeRef.get());
        this.resetSlot((Vec3i)this.slotRef.get());
        this.resetModel((Spatial)this.modelRef.get());
        this.resetCountLabel((Integer)this.countRef.get(), (Integer)this.maxCountRef.get());
    }

    public Item getItem() {
        return this.item;
    }

    public void reset() {
        this.resetModel((Spatial)this.modelRef.get());
    }

    public void updateLogicalState(float tpf) {
        super.updateLogicalState(tpf);
        if (this.itemSizeRef.update()) {
            this.resetItemSize((InventorySize2d)this.itemSizeRef.get());
        }
        if (this.slotRef.update()) {
            this.resetSlot((Vec3i)this.slotRef.get());
        }
        if (this.modelRef.update()) {
            this.resetModel((Spatial)this.modelRef.get());
        }
        boolean countChange = false;
        if (this.countRef.update()) {
            countChange = true;
        }
        if (this.maxCountRef.update()) {
            countChange = true;
        }
        if (countChange) {
            this.resetCountLabel((Integer)this.countRef.get(), (Integer)this.maxCountRef.get());
        }
    }

    protected void resetItemSize(InventorySize2d itemSize) {
        if (this.modelRef.get() == null) {
            return;
        }
        Spatial model = (Spatial)this.modelRef.get();
        Node parent = model.getParent();
        model.removeFromParent();
        model.setLocalScale(1.0f);
        model.setLocalTranslation(0.0f, 0.0f, 0.0f);
        model.setLocalRotation(itemSize.getRotation().toQuaternion());
        BoundingBox bb = (BoundingBox)model.getWorldBound();
        this.bbSize.set(new Vec3d(bb.getExtent(null)).multLocal(2.0));
        double slotWidth = itemSize.getXSlots();
        double slotHeight = itemSize.getYSlots();
        double x = slotWidth / this.bbSize.x;
        double y = slotHeight / this.bbSize.y;
        double scale = Math.min(x, y) * 0.9;
        model.setLocalScale((float)scale);
        double xOffset = slotWidth * 0.5 - (double)bb.getCenter().x * scale;
        double yOffset = -slotHeight * 0.5 - (double)bb.getCenter().y * scale;
        double zOffset = 0.0 - (double)(bb.getCenter().z - bb.getZExtent()) * scale;
        model.setLocalTranslation((float)xOffset, (float)yOffset, (float)zOffset);
        this.resetLabelPosition();
        if (testBackground) {
            this.testQuad.updateGeometry((float)slotWidth, (float)slotHeight);
            this.testGeom.updateModelBound();
            this.testGeom.setLocalTranslation(0.0f, (float)(-slotHeight), 0.0f);
        }
        if (parent != null) {
            parent.attachChild(model);
        }
    }

    public void forcePosition(Vec3i slot) {
        log.info("forcePosition(" + slot + ")");
        Vector3f v = slot.toVector3f();
        v.y = -v.y;
        this.setLocalTranslation(v);
    }

    protected void resetSlot(Vec3i slot) {
        log.info("resetSlot(" + slot + ") @" + System.identityHashCode((Object)this));
        Vector3f v = slot.toVector3f();
        v.y = -v.y;
        this.setLocalTranslation(v);
    }

    protected void resetCountLabel(int count, int maxCount) {
        if (maxCount == 1) {
            if (this.countLabel != null) {
                this.countLabel.removeFromParent();
                this.countLabel = null;
            }
            return;
        }
        if (this.countLabel == null) {
            this.countLabel = new Label("10/10");
            this.countLabel.setLocalScale(labelScale);
            this.countLabel.setColor(ColorRGBA.White);
            this.countLabel.setShadowColor(ColorRGBA.Black);
            this.attachChild((Spatial)this.countLabel);
        }
        this.countLabel.setText(count + "/" + maxCount);
        this.resetLabelPosition();
    }

    protected void resetLabelPosition() {
        if (this.countLabel == null) {
            return;
        }
        InventorySize2d itemSize = (InventorySize2d)this.itemSizeRef.get();
        double slotWidth = itemSize.getXSlots();
        double slotHeight = itemSize.getYSlots();
        double x = slotWidth / this.bbSize.x;
        double y = slotHeight / this.bbSize.y;
        double scale = Math.min(x, y) * 0.9;
        Vector3f pref = this.countLabel.getPreferredSize().mult(this.countLabel.getLocalScale().x);
        this.countLabel.setLocalTranslation((float)(slotWidth - (double)pref.x), (float)(-(slotHeight - (double)pref.y)), (float)(this.bbSize.z * scale));
    }

    public void resetModel(Spatial model) {
        if (model != null) {
            model.removeFromParent();
        }
        this.resetItemSize((InventorySize2d)this.itemSizeRef.get());
        this.resetSlot((Vec3i)this.slotRef.get());
        if (model != null) {
            this.attachChild(model);
        }
    }
}

