/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.map;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineQuad {
    static Logger log = LoggerFactory.getLogger(LineQuad.class);
    private Vector3f end1 = new Vector3f();
    private Vector3f end2 = new Vector3f();
    private ColorRGBA color;
    private float radius;
    private float v1 = 0.0f;
    private float v2 = 1.0f;
    private Mesh mesh;

    public LineQuad(ColorRGBA color) {
        this(color, 10.0f);
    }

    public LineQuad(ColorRGBA color, float radius) {
        this.color = color.clone();
        this.radius = radius;
        this.mesh = new Quad(radius, radius);
        this.resetTexCoords();
        this.resetColors();
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void updateStyle(float v1, float v2) {
        this.v1 = v1;
        this.v2 = v2;
        this.resetTexCoords();
    }

    public void updateEnds(Vector3f end1, Vector3f end2) {
        this.end1.set(end1);
        this.end2.set(end2);
        if (this.end1.distanceSquared(end2) == 0.0f) {
            this.end2.x += 1.0E-4f;
        }
        this.resetQuad();
    }

    public void updateColor(ColorRGBA color) {
        this.color.set(color);
        this.resetColors();
    }

    protected void resetQuad() {
        Vector3f dir = this.end2.subtract(this.end1).normalizeLocal();
        Vector3f offset = new Vector3f(-dir.y, dir.x, 0.0f);
        float x1 = this.end1.x;
        float y1 = this.end1.y;
        float x2 = this.end2.x;
        float y2 = this.end2.y;
        float xOffset = offset.x * this.radius;
        float yOffset = offset.y * this.radius;
        this.mesh.setBuffer(VertexBuffer.Type.Position, 3, new float[]{x1 + xOffset, y1 + yOffset, 0.0f, x1 - xOffset, y1 - yOffset, 0.0f, x2 - xOffset, y2 - yOffset, 0.0f, x2 + xOffset, y2 + yOffset, 0.0f});
        this.mesh.updateBound();
        this.mesh.clearCollisionData();
    }

    protected void resetTexCoords() {
        float u1 = 0.0f;
        float u2 = 1.0f;
        this.mesh.setBuffer(VertexBuffer.Type.TexCoord, 2, new float[]{u1, this.v1, u1, this.v2, u2, this.v2, u2, this.v1});
    }

    protected void resetColors() {
        this.mesh.setBuffer(VertexBuffer.Type.Color, 4, new float[]{this.color.r, this.color.g, this.color.b, this.color.a, this.color.r, this.color.g, this.color.b, this.color.a, this.color.r, this.color.g, this.color.b, this.color.a, this.color.r, this.color.g, this.color.b, this.color.a});
    }
}

