/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.object;

import com.jme3.material.MatParamOverride;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.shader.VarType;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.CellData;
import com.simsilica.mblock.LightUtils;
import com.simsilica.mblock.SafeCellData;
import com.simsilica.mblock.geom.GeometryFactory;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import mythruna.assembly.AssemblyShape;
import mythruna.assembly.Joint;
import mythruna.assembly.MixControl;
import mythruna.assembly.PartJointController;
import mythruna.client.view.object.SpatialUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialFactory {
    static Logger log = LoggerFactory.getLogger(SpatialFactory.class);
    private GeometryFactory geomFactory;
    private Predicate<Geometry> carveIncludes;
    private boolean debugJoints;

    public SpatialFactory(GeometryFactory geomFactory, Predicate<Geometry> carveIncludes) {
        this.geomFactory = geomFactory;
        this.carveIncludes = carveIncludes;
    }

    public Spatial createSpatial(MBlockShape shape) {
        MixControl mix = null;
        HashMap<Part, Joint> jointIndex = null;
        if (shape instanceof AssemblyShape) {
            mix = new MixControl();
            jointIndex = new HashMap<Part, Joint>();
            AssemblyShape asmShape = (AssemblyShape)shape;
            for (PartJointController controller : asmShape.getJoints()) {
                jointIndex.put((Part)controller.getTarget(), controller.getJoint());
            }
        }
        Part part = shape.getPart();
        Spatial result = this.createPartSpatial(part, mix, jointIndex);
        if (mix != null && mix.hasJoints()) {
            result.addControl((Control)mix);
        }
        return result;
    }

    protected Spatial createPartSpatial(Part part, MixControl mix, Map<Part, Joint> jointIndex) {
        if (part instanceof CellArrayPart) {
            return this.createCellArrayPart((CellArrayPart)part);
        }
        if (part instanceof Group) {
            return this.createGroupPart((Group)part, mix, jointIndex);
        }
        throw new IllegalArgumentException("Unhandled part type:" + part);
    }

    protected Spatial createCellArrayPart(CellArrayPart part) {
        if (part.getType() == CellArrayPart.Type.Sphere) {
            return SpatialUtils.createDebugSphere("sphere:" + part.getName(), (float)part.getMass().getRadius(), ColorRGBA.Red, null);
        }
        Node parts = new Node("parts:" + part.getName());
        CellArray cells = part.getCells();
        CellArray lights = new CellArray(cells.getSizeX(), cells.getSizeY(), cells.getSizeZ());
        LightUtils.recalculateLighting((CellData)cells, (CellData)lights, (int)0, (int)0, (int)0, (int)lights.getSizeX(), (int)lights.getSizeY(), (int)lights.getSizeZ());
        SafeCellData safeLights = new SafeCellData((CellData)lights, LightUtils.DIRECT_SUN);
        this.geomFactory.generateBlocks(parts, cells, (CellData)safeLights, true);
        if (SpatialUtils.isCarved(part.getName())) {
            log.info("Carving part:" + part.getName());
            float carveScale = (float)(1.0 / part.getScale());
            parts.addMatParamOverride(new MatParamOverride(VarType.Float, "CarveScale", (Object)Float.valueOf(carveScale)));
        }
        parts.setLocalScale((float)part.getScale());
        parts.setLocalTranslation(part.getLocalPosition().toVector3f());
        parts.setLocalRotation(part.getLocalOrientation().toQuaternion());
        parts.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        if (this.debugJoints) {
            parts.attachChild((Spatial)SpatialUtils.createDebugBox("box:" + part.getName(), 0.01f, ColorRGBA.Pink));
        }
        return parts;
    }

    protected Spatial createGroupPart(Group group, MixControl mix, Map<Part, Joint> jointIndex) {
        Node node = new Node(group.getName());
        for (Part child : group.getChildren()) {
            Spatial spatial = this.createPartSpatial(child, mix, jointIndex);
            node.attachChild(spatial);
        }
        if (mix != null) {
            Joint joint = jointIndex.get(group);
            log.info("Found joint:" + joint);
            if (joint != null) {
                mix.addJoint(joint, (Spatial)node);
                if (this.debugJoints) {
                    node.attachChild((Spatial)SpatialUtils.createDebugBox("box:" + group.getName(), 0.01f, ColorRGBA.Orange));
                }
            }
        }
        node.setLocalTranslation(group.getLocalPosition().toVector3f());
        node.setLocalRotation(group.getLocalOrientation().toQuaternion());
        if (this.debugJoints) {
            node.attachChild((Spatial)SpatialUtils.createDebugBox("box:" + group.getName(), 0.01f, ColorRGBA.Green));
        }
        return node;
    }
}

