/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.dnd;

import com.google.common.base.MoreObjects;
import com.jme3.collision.CollisionResult;
import com.jme3.math.Vector2f;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.dnd.DragSession;
import com.simsilica.lemur.event.AbstractCursorEvent;

public class DragEvent {
    private DragSession session;
    private AbstractCursorEvent cursorEvent;
    private CollisionResult collision;

    public DragEvent(DragSession session, AbstractCursorEvent cursorEvent) {
        this(session, cursorEvent, cursorEvent.getCollision());
    }

    public DragEvent(DragSession session, AbstractCursorEvent cursorEvent, CollisionResult collision) {
        this.session = session;
        this.cursorEvent = cursorEvent;
        this.collision = collision;
    }

    public DragSession getSession() {
        return this.session;
    }

    public float getX() {
        return this.cursorEvent.getX();
    }

    public float getY() {
        return this.cursorEvent.getY();
    }

    public Vector2f getLocation() {
        return new Vector2f(this.getX(), this.getY());
    }

    public CollisionResult getCollision() {
        return this.collision;
    }

    public ViewPort getViewPort() {
        return this.cursorEvent.getViewPort();
    }

    public Spatial getTarget() {
        return this.cursorEvent.getTarget();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("session", (Object)this.session).add("location", (Object)("[" + this.getX() + ", " + this.getY() + "]")).add("collision", (Object)this.getCollision()).add("viewPort", (Object)this.getViewPort()).add("target", (Object)this.getTarget()).toString();
    }
}

