/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mythruna.character.FabricOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingTemplate
implements Comparable<ClothingTemplate> {
    static Logger log = LoggerFactory.getLogger(ClothingTemplate.class);
    private String name;
    private String infoName;
    private List<FabricOption> options;

    private ClothingTemplate() {
    }

    public ClothingTemplate(String name, String infoName) {
        this.name = name;
        this.infoName = infoName;
        this.options = new ArrayList<FabricOption>();
    }

    public String getName() {
        return this.name;
    }

    public String getInfoName() {
        return this.infoName;
    }

    public List<FabricOption> getOptions() {
        return this.options;
    }

    public void expand() {
        for (FabricOption option : this.options) {
            option.expand();
        }
    }

    @Override
    public int compareTo(ClothingTemplate template) {
        int test = this.name.compareTo(template.name);
        if (test != 0) {
            return test;
        }
        test = this.infoName.compareTo(template.infoName);
        if (test != 0) {
            return test;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.infoName);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ClothingTemplate other = (ClothingTemplate)o;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.infoName, other.infoName)) {
            return false;
        }
        return Objects.equals(this.options, other.options);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("name", (Object)this.name).add("infoName", (Object)this.infoName).toString();
    }
}

