/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.Filters;
import com.simsilica.es.IndexedField;
import com.simsilica.es.PersistentComponent;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectTypeInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(ObjectTypeInfo.class);
    @IndexedField
    private int typeId;

    public ObjectTypeInfo() {
    }

    public ObjectTypeInfo(int typeId) {
        this.typeId = typeId;
    }

    public static ObjectTypeInfo create(String typeName, EntityData ed) {
        int id = ed.getStrings().getStringId(typeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(typeName, true);
        }
        return new ObjectTypeInfo(id);
    }

    public static ComponentFilter<ObjectTypeInfo> typeFilter(String typeName, EntityData ed) {
        int id = ed.getStrings().getStringId(typeName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(typeName, true);
        }
        return Filters.fieldEquals(ObjectTypeInfo.class, (String)"typeId", (Object)id);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getTypeName(EntityData ed) {
        if (this.typeId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.typeId);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ObjectTypeInfo other = (ObjectTypeInfo)o;
        return other.typeId == this.typeId;
    }

    public int hashCode() {
        return Objects.hash(this.typeId);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(EntityData ed) {
        String s = ed == null ? String.valueOf(this.typeId) : this.getTypeName(ed);
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("typeId", (Object)s).toString();
    }
}

