/*
 * Decompiled with CFR 0.152.
 */
package mythruna.es;

import com.google.common.base.MoreObjects;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.PersistentComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundInfo
implements EntityComponent,
PersistentComponent {
    static Logger log = LoggerFactory.getLogger(SoundInfo.class);
    public static final byte TYPE_EFFECT = 0;
    public static final byte TYPE_AMBIENT = 1;
    private int soundId = -1;
    private long startTime;
    private double volume;
    private boolean looping;
    private byte type;

    private SoundInfo() {
    }

    public SoundInfo(int soundId, long startTime, double volume, boolean looping) {
        this(soundId, 0, startTime, volume, looping);
    }

    public SoundInfo(int soundId, byte type, long startTime, double volume, boolean looping) {
        this.soundId = soundId;
        this.type = type;
        this.startTime = startTime;
        this.volume = volume;
        this.looping = looping;
    }

    public static SoundInfo create(String soundName, long startTime, double volume, boolean looping, EntityData ed) {
        return SoundInfo.create(soundName, (byte)0, startTime, volume, looping, ed);
    }

    public static SoundInfo create(String soundName, byte type, long startTime, double volume, boolean looping, EntityData ed) {
        int id = ed.getStrings().getStringId(soundName, false);
        if (id < 0) {
            id = ed.getStrings().getStringId(soundName, true);
        }
        return new SoundInfo(id, startTime, volume, looping);
    }

    public SoundInfo changeVolume(double volume) {
        return new SoundInfo(this.soundId, this.type, this.startTime, volume, this.looping);
    }

    public SoundInfo changeStartTime(long startTime) {
        return new SoundInfo(this.soundId, this.type, startTime, this.volume, this.looping);
    }

    public int getSoundId() {
        return this.soundId;
    }

    public String getSoundName(EntityData ed) {
        if (this.soundId == -1) {
            return null;
        }
        return ed.getStrings().getString(this.soundId);
    }

    public byte getType() {
        return this.type;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public double getVolume() {
        return this.volume;
    }

    public boolean isLooping() {
        return this.looping;
    }

    public String toString(EntityData ed) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)this.getClass().getSimpleName());
        if (this.soundId != -1 && ed != null) {
            helper.add("soundName", (Object)this.getSoundName(ed));
        } else {
            helper.add("soundId", this.soundId);
        }
        helper.add("type", (int)this.type).add("startTime", this.startTime).add("volume", this.volume).add("looping", this.looping);
        return helper.toString();
    }

    public String toString() {
        return this.toString(null);
    }
}

