/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.time;

import com.simsilica.es.Entity;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import mythruna.es.ScheduledAction;
import mythruna.es.ScheduledTime;
import mythruna.sim.GameActionSystem;
import mythruna.world.WorldTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulingSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(SchedulingSystem.class);
    private EntityData ed;
    private GameActionSystem gameActions;
    private WorldTime worldTime;
    private long nextSequenceId;
    private SortedSet<ScheduleEntry> schedule = new TreeSet<ScheduleEntry>();
    private TimeContainer times;
    private ActionContainer actions;

    protected void initialize() {
        log.info("initialize()");
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.gameActions = (GameActionSystem)((Object)this.getSystem(GameActionSystem.class, true));
        this.worldTime = (WorldTime)this.getSystem(WorldTime.class, true);
        this.times = new TimeContainer(this.ed);
        this.actions = new ActionContainer(this.ed);
    }

    public void start() {
        this.times.start();
        this.actions.start();
    }

    protected void terminate() {
        this.times.stop();
        this.actions.stop();
    }

    public void update(SimTime time) {
        this.times.update();
        this.actions.update();
        if (this.schedule.isEmpty()) {
            return;
        }
        long t = time.getTime();
        ScheduleEntry first = this.schedule.first();
        if (first.atTime > t) {
            return;
        }
        first.toDo.accept(t);
        this.schedule.remove(first);
    }

    protected void runAction(EntityId target, String action) {
        log.info("runAction(" + target + ", " + action + ")");
        try {
            this.gameActions.runAction(target, action, new Object[0]);
        }
        catch (Exception e) {
            log.error("Error running:" + action + " on:" + target, (Throwable)e);
        }
    }

    protected class TimeContainer
    extends EntityContainer<ScheduleEntry> {
        public TimeContainer(EntityData ed) {
            super(ed, new Class[]{ScheduledTime.class});
        }

        protected ScheduleEntry addObject(Entity entity) {
            ScheduleEntry object = new ScheduleEntry(entity);
            this.updateObject(object, entity);
            return object;
        }

        protected void updateObject(ScheduleEntry object, Entity entity) {
            ScheduledTime time = (ScheduledTime)entity.get(ScheduledTime.class);
            long at = time.getAtTime() - SchedulingSystem.this.worldTime.getBaseOffset();
            log.info("schedule:" + at + " entity:" + entity.getId());
            object.schedule(SchedulingSystem.this.nextSequenceId++, at, now -> {
                SchedulingSystem.this.runAction(entity.getId(), "onScheduledTime");
                SchedulingSystem.this.ed.setComponent(entity.getId(), (EntityComponent)time.nextTimeAfter((long)now));
            });
        }

        protected void removeObject(ScheduleEntry object, Entity entity) {
            SchedulingSystem.this.schedule.remove(object);
        }
    }

    protected class ActionContainer
    extends EntityContainer<ScheduleEntry> {
        public ActionContainer(EntityData ed) {
            super(ed, new Class[]{ScheduledAction.class});
        }

        protected ScheduleEntry addObject(Entity entity) {
            ScheduleEntry object = new ScheduleEntry(entity);
            this.updateObject(object, entity);
            return object;
        }

        protected void updateObject(ScheduleEntry object, Entity entity) {
            ScheduledAction action = (ScheduledAction)entity.get(ScheduledAction.class);
            long at = action.getAtTime() - SchedulingSystem.this.worldTime.getBaseOffset();
            log.info("action:" + at + " entity:" + entity.getId() + " action:" + action.getAction(SchedulingSystem.this.ed));
            object.schedule(SchedulingSystem.this.nextSequenceId++, at, now -> {
                SchedulingSystem.this.runAction(action.getTarget(), action.getAction(SchedulingSystem.this.ed));
                SchedulingSystem.this.ed.removeComponent(entity.getId(), ScheduledAction.class);
            });
        }

        protected void removeObject(ScheduleEntry object, Entity entity) {
            SchedulingSystem.this.schedule.remove(object);
        }
    }

    protected class ScheduleEntry
    implements Comparable<ScheduleEntry> {
        private Entity entity;
        private long atTime;
        private Consumer<Long> toDo;
        private long sequence;

        public ScheduleEntry(Entity entity) {
            this.entity = entity;
        }

        public void schedule(long sequence, long atTime, Consumer<Long> toDo) {
            SchedulingSystem.this.schedule.remove(this);
            this.sequence = sequence;
            this.atTime = atTime;
            this.toDo = toDo;
            SchedulingSystem.this.schedule.add(this);
        }

        @Override
        public int compareTo(ScheduleEntry other) {
            int result = Long.compare(this.atTime, other.atTime);
            if (result != 0) {
                return result;
            }
            return Long.compare(this.sequence, other.sequence);
        }
    }
}

