#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/MultiSample.glsllib"

uniform COLORTEXTURE m_Texture;
uniform DEPTHTEXTURE m_DepthTexture;
varying vec2 texCoord;

uniform vec4 m_BaseColor;
uniform vec4 m_DepthColor;

uniform vec2 g_FrustumNearFar;

uniform float m_WaterLevel;

//#define BLUR_ENABLED

void main() {

    vec4 texVal = getColor( m_Texture, texCoord );

    if( texCoord.y > m_WaterLevel ) {
        gl_FragColor = texVal;
        return;
    }

    float zBuffer = getDepth( m_DepthTexture, texCoord ).r;

    //
    // z_buffer_value = a + b / z;
    //
    // Where:
    //  a = zFar / ( zFar - zNear )
    //  b = zFar * zNear / ( zNear - zFar )
    //  z = distance from the eye to the object
    //
    // Which means:
    // zb - a = b / z;
    // z * (zb - a) = b
    // z = b / (zb - a)
    //
    float a = g_FrustumNearFar.y / (g_FrustumNearFar.y - g_FrustumNearFar.x);
    float b = g_FrustumNearFar.y * g_FrustumNearFar.x / (g_FrustumNearFar.x - g_FrustumNearFar.y);
    float z = b / (zBuffer - a);

    // Above could be the same for any depth-based filter

    // Depth attenuation is similar 
    float attenuation = min(1.0, z / ATTENUATION_DISTANCE);

    #ifdef BLUR_ENABLED
        // We want to be purely focused right at 0 and be purely unfocused at BLUR_DISTANCE.
        // 'unfocus' will control how much to mix in the blurred image.
        float unfocus = min(1.0, z / BLUR_DISTANCE);
    
        // Perform a wide convolution filter and we scatter it
        // a bit to avoid some texture look-ups.  Instead of
        // a full 5x5 (25-1 lookups) we'll skip every other one
        // to only perform 12.
        // 1  0  1  0  1
        // 0  1  0  1  0
        // 1  0  x  0  1
        // 0  1  0  1  0
        // 1  0  1  0  1
        //
        // You can get away with 8 just around the outside but
        // it looks more jittery to me.

        vec4 sum = vec4(0.0);

        float x = texCoord.x;
        float y = texCoord.y;

        // In order from lower left to right, depending on how you look at it
        sum += texture2D( m_Texture, vec2(x - 2.0 * X_SCALE, y - 2.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x - 0.0 * X_SCALE, y - 2.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x + 2.0 * X_SCALE, y - 2.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x - 1.0 * X_SCALE, y - 1.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x + 1.0 * X_SCALE, y - 1.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x - 2.0 * X_SCALE, y - 0.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x + 2.0 * X_SCALE, y - 0.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x - 1.0 * X_SCALE, y + 1.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x + 1.0 * X_SCALE, y + 1.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x - 2.0 * X_SCALE, y + 2.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x - 0.0 * X_SCALE, y + 2.0 * Y_SCALE) );
        sum += texture2D( m_Texture, vec2(x + 2.0 * X_SCALE, y + 2.0 * Y_SCALE) );

        sum = sum / 12.0;
 
        vec4 color = mix(texVal, sum, unfocus);
    #else
        // The blur doesn't work right unless we've applied fog first.
        // Otherwise it creates weird edge artifacts where bright edges meet
        // far values.
        vec4 color = texVal;
    #endif   
    
    //float brightness = max(texVal.r, max(texVal.g, texVal.b));
    //vec4 color = mix(texVal, sum, unfocus);
    
    //color = texVal;
    
    //float brightness = max(color.r, max(color.g, color.b));
    float brightness = color.r * 0.2126 + color.g * 0.7152 + color.b * 0.0722;
    //brightness *= 2.0;
    //brightness = min(1.0, brightness);
    
    // Anything brighter than max is 1.0 anything lower than min is min
    // and everything else is stretched.  This makes sure that dark areas
    // have some minimum blue color but most areas are 'brightish'
    float minBrightness = 0.25;
    float maxBrightness = 0.75;
    float scale = 1.0 / (maxBrightness - minBrightness);
    brightness = minBrightness + max(0.0, brightness - minBrightness) * scale;
 
    // Beyond a certain distance brightness should fade to a common value
    // We'll consider double the attenuation distance to be the max attenuation
    // for now.
    float farAttenuation = min(1.0, max(0.0, z - ATTENUATION_DISTANCE) / ATTENUATION_DISTANCE);    
    // 0 when at attenuation distance, 1.0 when at 2x attenuation distance
    brightness = 0.5 + (brightness - 0.5) * (1.0 - farAttenuation); 
        
    color = color * m_BaseColor;
    //gl_FragColor = mix(color, m_DepthColor * brightness, attenuation);
    vec4 fogColor = m_DepthColor * brightness;
    attenuation = 1.0 - attenuation;
    attenuation *= attenuation * attenuation * attenuation;
    attenuation = 1.0 - attenuation;
    gl_FragColor = mix(color, fogColor, attenuation);
    //gl_FragColor = color;

    #ifdef DEBUG_UNFOCUS
        // Used for debugging the range or user settings
        gl_FragColor.r = unfocus;
        gl_FragColor.g = unfocus;
        gl_FragColor.b = unfocus;
    #endif

    #ifdef DEBUG_BRIGHTNESS
        // Used for debugging the range or user settings
        //gl_FragColor.r = brightness;
        //gl_FragColor.g = brightness;
        //gl_FragColor.b = brightness;
        gl_FragColor.rgb = fogColor.rgb;
    #endif
    
    #ifdef DEBUG_ATTENUATION
        // Used for debugging the range or user settings
        gl_FragColor.r = attenuation;
        gl_FragColor.g = attenuation;
        gl_FragColor.b = attenuation;
    #endif
}
