#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Instancing.glsllib"
#import "Common/ShaderLib/Lighting.glsllib"

#import "MatDefs/terrain/TerrainTiles.glsllib"

// fog - jayfella
#ifdef USE_FOG
    varying float fog_distance;
    uniform vec3 g_CameraPosition;
#endif

//uniform vec4 m_Ambient;
//uniform vec4 m_Diffuse;
uniform vec4 m_Specular;
//uniform float m_Shininess;

uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;
uniform vec4 g_AmbientLightColor;

varying vec2 texCoord;

varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;

attribute vec3 inPosition;

varying vec3 lightVec;
varying vec3 vNormal;
varying vec3 vViewDir;
varying vec4 vLightDir;

varying vec3 mPos;
varying vec3 wNormal;

const float NORMAL_SAMPLE = 1.0; //0.5;

void main(){
    vec4 modelSpacePos = vec4(inPosition, 1.0);
    vec3 modelSpaceNorm = vec3(0.0, 1.0, 0.0);

    vec2 terrainPos = modelToTerrainPos(modelSpacePos.xyz);
    texCoord = terrainPosToUv(terrainPos);

    float yOffset = modelSpacePos.y;
    modelSpacePos.y = getElevation(terrainPos);

    mPos = modelSpacePos.xyz;

    #ifdef CALCULATE_NORMALS
        // Calculate the normal
        // We'll just do two samples
        float temp = getElevation(vec2(terrainPos.x + NORMAL_SAMPLE, terrainPos.y));
        float elevLeft = modelSpacePos.y - temp;
        temp = getElevation(vec2(terrainPos.x, terrainPos.y + NORMAL_SAMPLE));
        float elevFwd = modelSpacePos.y - temp;

        vec3 leftNorm = normalize(vec3(elevLeft, NORMAL_SAMPLE, 0.0));
        vec3 fwdNorm = normalize(vec3(0.0, NORMAL_SAMPLE, elevFwd));

        modelSpaceNorm = normalize((leftNorm + fwdNorm) * 0.5);
    #endif

    // Now that modelSpacePos has been used to calculate normals and stuff
    // we can add in its offset.  For the skirt effect to work, all things
    // must match exactly with the same ring at the terrain layer... it's supposed
    // to look stretched and that will invisibly cover any gaps between the LODs.
    modelSpacePos.y += yOffset;

    vec4 maskValue = getViewMask(modelSpacePos.xyz);
    if( maskValue.r > 0.5 ) {
        modelSpacePos.y -= 2.0;
    }

    gl_Position = TransformWorldViewProjection(modelSpacePos);

    // Implement logarithmic z-buffer for terrain
    //float farplane = 8000.0;
    //float Fcoef = 2.0 / log2(farplane + 1.0);
    //gl_Position.z = log2(max(1e-6, 1.0 + gl_Position.w)) * Fcoef - 1.0;
    // From: https://outerra.blogspot.com/2013/07/logarithmic-depth-buffer-optimizations.html
    // but things seem backwards so the depth test function may also need to
    // be adjusted and I'd rather explore solutions that don't require all materials
    // to do this.

    vec3 wvPosition = TransformWorldView(modelSpacePos).xyz;
    vec3 wvNormal  = normalize(TransformNormal(modelSpaceNorm));
    vec3 viewDir = normalize(-wvPosition);

    // Right now we don't rotate our terrain into strange angles
    // so the modelSpaceNorm is also the world space norm.  If we ever allow
    // terrain transforms then will have to multiply by world rotation.
    wNormal = modelSpaceNorm;

    vec4 wvLightPos = (g_ViewMatrix * vec4(g_LightPosition.xyz,clamp(g_LightColor.w,0.0,1.0)));
    wvLightPos.w = g_LightPosition.w;
    vec4 lightColor = g_LightColor;

    vNormal = wvNormal;
    vViewDir = viewDir;
    lightComputeDir(wvPosition, lightColor.w, wvLightPos, vLightDir, lightVec);

    AmbientSum  = g_AmbientLightColor.rgb;
    DiffuseSum  =  vec4(lightColor.rgb, 1.0);
    SpecularSum = (m_Specular * lightColor).rgb;

    #ifdef USE_FOG
        fog_distance = distance(g_CameraPosition, (g_WorldMatrix * modelSpacePos).xyz);
    #endif
}
