/*
 * Decompiled with CFR 0.152.
 */
package mythruna.net.info;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import mythruna.net.info.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostList {
    static Logger log = LoggerFactory.getLogger(HostList.class);
    public static final int FORMAT_VERSION = 1;
    private int formatVersion;
    private List<HostInfo> publicHosts;

    public static HostList load(URL u) throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        String json = Resources.toString((URL)u, (Charset)Charsets.UTF_8);
        return (HostList)gson.fromJson(json, HostList.class);
    }

    public void upgrade() {
        for (HostInfo host : this.publicHosts) {
            host.upgrade();
        }
    }

    public List<HostInfo> getPublicHosts() {
        return this.publicHosts;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("publicHosts", this.publicHosts).toString();
    }
}

