/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.google.common.base.MoreObjects;
import java.util.function.Predicate;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.Signal;
import mythruna.sim.ai.SignalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteredSignalHandler<T>
implements SignalHandler<T> {
    static Logger log = LoggerFactory.getLogger(FilteredSignalHandler.class);
    private Class<Signal<T>> signalClass;
    private String type;
    private Predicate<Signal<? extends T>> predicate;
    private SignalHandler<T> delegate;

    public FilteredSignalHandler(String type, SignalHandler<T> delegate) {
        this(null, type, null, delegate);
    }

    public FilteredSignalHandler(Class<Signal<T>> signalClass, String type, SignalHandler<T> delegate) {
        this(signalClass, type, null, delegate);
    }

    public FilteredSignalHandler(Class<Signal<T>> signalClass, String type, Predicate<Signal<? extends T>> predicate, SignalHandler<T> delegate) {
        this.signalClass = signalClass;
        this.type = type;
        this.predicate = predicate;
        this.delegate = delegate;
    }

    public SignalHandler<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public Reaction generateReaction(Brain brain, Signal<? extends T> signal) {
        if (this.signalClass != null && !this.signalClass.isInstance(signal)) {
            return null;
        }
        if (this.type != null && !this.type.equals(signal.getType())) {
            return null;
        }
        if (this.predicate != null && !this.predicate.test(signal)) {
            return null;
        }
        return this.delegate.generateReaction(brain, signal);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("signalClass", this.signalClass).add("type", (Object)this.type).add("predicate", this.predicate).add("delegate", this.delegate).toString();
    }
}

