/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.base.protocol;

import com.jme3.network.Message;
import com.jme3.network.base.MessageBuffer;
import com.jme3.network.base.MessageProtocol;
import com.jme3.network.base.protocol.LazyMessageBuffer;
import com.jme3.network.serializing.Serializer;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SerializerMessageProtocol
implements MessageProtocol {
    @Override
    public ByteBuffer toByteBuffer(Message message, ByteBuffer target) {
        ByteBuffer buffer = target == null ? ByteBuffer.allocate(32769) : target;
        try {
            buffer.position(2);
            Serializer.writeClassAndObject(buffer, message);
            buffer.flip();
            short dataLength = (short)(buffer.remaining() - 2);
            buffer.putShort(dataLength);
            buffer.position(0);
            return buffer;
        }
        catch (IOException e) {
            throw new RuntimeException("Error serializing message", e);
        }
    }

    @Override
    public Message toMessage(ByteBuffer bytes) {
        try {
            return (Message)Serializer.readClassAndObject(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Error deserializing object, class ID:" + bytes.getShort(0), e);
        }
    }

    @Override
    public MessageBuffer createBuffer() {
        return new LazyMessageBuffer(this);
    }
}

