/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.anim.AnimComposer;
import com.jme3.anim.SkinningControl;
import com.jme3.anim.tween.action.BlendAction;
import com.jme3.anim.tween.action.BlendSpace;
import com.jme3.anim.tween.action.LinearBlendSpace;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.SceneGraphVisitorAdapter;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Quad;
import com.simsilica.crig.AttachmentInfo;
import com.simsilica.crig.BlendInfo;
import com.simsilica.crig.ColliderInfo;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.RigType;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.crig.jme.AnimComposerShape;
import com.simsilica.crig.jme.AttachmentControl;
import com.simsilica.crig.jme.AttachmentPointImpl;
import com.simsilica.crig.jme.ColliderShape;
import com.simsilica.crig.jme.RigTypeInitializer;
import com.simsilica.crig.jme.VariationHandler;
import com.simsilica.ext.mphys.Mass;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.phys.CellArrayPart;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.Part;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialRigType
implements RigType,
Serializable {
    static Logger log = LoggerFactory.getLogger(SpatialRigType.class);
    static final long serialVersionUID = 42L;
    private transient Spatial spatial;
    private List<ColliderInfo> colliders;
    private List<AttachmentInfo> attachments;
    private List<BlendInfo> blends;
    private List<RigTypeInitializer> initializers;
    private transient Map<String, VariationHandler> variationHandlers = new HashMap<String, VariationHandler>();
    private transient boolean initialized;

    public SpatialRigType(Spatial spatial, List<ColliderInfo> colliders, List<AttachmentInfo> attachments, List<BlendInfo> blends, List<RigTypeInitializer> initializers) {
        this.spatial = spatial.clone();
        this.colliders = colliders;
        this.attachments = attachments;
        this.blends = blends;
        this.initializers = initializers;
        this.spatial.depthFirstTraversal((SceneGraphVisitor)new SceneGraphVisitorAdapter(){

            public void visit(Geometry geom) {
                if (log.isTraceEnabled()) {
                    log.trace("Clearing mesh from:" + geom);
                }
                geom.setMaterial(null);
                geom.setMesh((Mesh)new Quad(1.0f, 1.0f));
            }
        });
        this.initialize();
    }

    protected void setVariationHandler(String type, VariationHandler handler) {
        this.variationHandlers.put(type, handler);
    }

    protected VariationHandler getVariationHandler(String type) {
        return this.variationHandlers.get(type);
    }

    protected Set<String> getVariationTypes() {
        return this.variationHandlers.keySet();
    }

    protected List<RigTypeInitializer> getInitializers() {
        return this.initializers;
    }

    protected void initialize() {
        if (log.isTraceEnabled()) {
            log.trace("initialize() initializers:" + this.initializers);
        }
        if (this.initialized) {
            return;
        }
        this.variationHandlers = new HashMap<String, VariationHandler>();
        if (this.initializers == null) {
            log.warn("Rig has no initializers:" + this.spatial.getKey() + " spatial:" + this.spatial);
        } else {
            for (RigTypeInitializer init : this.initializers) {
                if (log.isTraceEnabled()) {
                    log.trace("running:" + init);
                }
                init.initializeRigType(this);
            }
        }
        this.initialized = true;
    }

    @Override
    public RigShape createShape(String name, double scale, Mass mass) {
        this.initialize();
        Spatial view = this.spatial.clone();
        view.setLocalScale((float)scale);
        AnimComposer anim = AnimComposerRig.findControl(view, AnimComposer.class);
        if (anim == null) {
            throw new IllegalArgumentException("View has no anim composer");
        }
        SkinningControl skin = AnimComposerRig.findControl(view, SkinningControl.class);
        anim.setGlobalSpeed(0.0f);
        double m = mass == null ? 0.0 : mass.getMass();
        Group root = new Group("rig");
        boolean first = true;
        ArrayList<ColliderShape> shapes = new ArrayList<ColliderShape>();
        for (ColliderInfo c : this.colliders) {
            if (log.isTraceEnabled()) {
                log.trace("c:" + c);
            }
            if (skin.getArmature().getJoint(c.getJoint()) == null) {
                log.warn("No joint found for:" + c.getJoint());
                continue;
            }
            Node att = skin.getAttachmentsNode(c.getJoint());
            double partMass = 0.01;
            if (first) {
                partMass = m;
                first = false;
            }
            CellArrayPart part = c.getShape() == null ? CellArrayPart.createSphere((String)c.getName(), (double)(c.getScale() * scale), (double)partMass) : CellArrayPart.createShape((String)c.getName(), (CellArray)c.getShape(), (double)(c.getScale() * scale), (double)partMass);
            ColliderShape shape = new ColliderShape(c, (Spatial)att, (Part)part);
            shape.update();
            root.addChild((Part)part);
            shapes.add(shape);
        }
        ColliderShape[] array = shapes.toArray(new ColliderShape[0]);
        ArrayList<AttachmentPointImpl> points = new ArrayList<AttachmentPointImpl>();
        if (this.attachments != null) {
            for (AttachmentInfo a : this.attachments) {
                if (log.isTraceEnabled()) {
                    log.trace("a:" + a);
                }
                if (skin.getArmature().getJoint(a.getJoint()) == null) {
                    log.warn("No joint found for:" + a.getJoint());
                    continue;
                }
                Node node = skin.getAttachmentsNode(a.getJoint());
                AttachmentPointImpl point = new AttachmentPointImpl(a, (Spatial)node);
                point.update();
                points.add(point);
            }
        }
        AttachmentPointImpl[] pointArray = points.toArray(new AttachmentPointImpl[0]);
        AnimComposerRig delegate = new AnimComposerRig(anim, null);
        if (this.blends != null) {
            for (BlendInfo blend : this.blends) {
                if (log.isTraceEnabled()) {
                    log.trace("blend:" + blend);
                }
                BlendAction ba = anim.actionBlended(blend.getName(), (BlendSpace)new LinearBlendSpace(0.0f, 1.0f), blend.getBlendedActions());
                ba.getBlendSpace().setValue((float)blend.getDefaultBlend());
            }
        } else {
            log.warn("BlendInfo list is null, this might be an older serialized version");
        }
        return new AnimComposerShape(this, root, delegate, () -> {
            anim.update(0.1f);
            skin.update(0.1f);
        }, array, pointArray);
    }

    public void configureSpatial(Spatial view) {
        this.initialize();
        AnimComposer anim = AnimComposerRig.findControl(view, AnimComposer.class);
        anim.setGlobalSpeed(0.0f);
        if (this.blends != null) {
            for (BlendInfo blend : this.blends) {
                if (log.isTraceEnabled()) {
                    log.trace("blend:" + blend);
                }
                BlendAction ba = anim.actionBlended(blend.getName(), (BlendSpace)new LinearBlendSpace(0.0f, 1.0f), blend.getBlendedActions());
                ba.getBlendSpace().setValue((float)blend.getDefaultBlend());
            }
        } else {
            log.warn("BlendInfo list is null, this might be an older serialized version");
        }
        AttachmentControl existing = AnimComposerRig.findControl(view, AttachmentControl.class);
        if (existing != null) {
            throw new IllegalArgumentException("View already has an attachment control.");
        }
        view.addControl((Control)new AttachmentControl(this));
    }

    protected AttachmentInfo findAttachmentInfo(String name) {
        if (this.attachments == null) {
            return null;
        }
        for (AttachmentInfo att : this.attachments) {
            if (!Objects.equals(att.getName(), name)) continue;
            return att;
        }
        return null;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        byte[] array = (byte[])stream.readObject();
        this.spatial = (Spatial)BinaryImporter.getInstance().load(array);
        if (log.isTraceEnabled()) {
            log.trace("read spatial array size:" + array.length);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        BinaryExporter.getInstance().save((Savable)this.spatial, (OutputStream)bos);
        byte[] array = bos.toByteArray();
        stream.writeObject(array);
        if (log.isTraceEnabled()) {
            log.trace("wrote spatial array size:" + array.length);
        }
    }
}

