/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.phys;

import com.simsilica.mathd.Matrix3d;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.phys.Group;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.BodyMass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MassUtils {
    static Logger log = LoggerFactory.getLogger(MassUtils.class);

    public static double getMass(int type) {
        return type == 0 ? 0.0 : 1.0;
    }

    public static BodyMass calculateBodyMass(Group group) {
        double totalMass = 0.0;
        Vec3d center = new Vec3d();
        for (Part child : group.getChildren()) {
            BodyMass m = child.getMass();
            if (m.getInverseMass() == 0.0) continue;
            double mass = 1.0 / m.getInverseMass();
            totalMass += mass;
            Vec3d pos = child.getLocalPosition();
            pos = pos.add(child.getLocalOrientation().mult(m.getCog()));
            center.addLocal(pos.x * mass, pos.y * mass, pos.z * mass);
        }
        if (totalMass == 0.0) {
            return null;
        }
        center.multLocal(1.0 / totalMass);
        double radius = 0.0;
        double[][] tensor = new double[3][3];
        int X = 0;
        int Y = 1;
        int Z = 2;
        for (Part child : group.getChildren()) {
            BodyMass bodyMass = child.getMass();
            double m = 1.0 / bodyMass.getInverseMass();
            Matrix3d imt = bodyMass.getInverseMassTensor();
            Matrix3d mt = imt.invert();
            Vec3d pos = child.getLocalPosition();
            pos = pos.add(child.getLocalOrientation().mult(bodyMass.getCog()));
            double x = pos.x - center.x;
            double y = pos.y - center.y;
            double z = pos.z - center.z;
            double[] dArray = tensor[X];
            int n = X;
            dArray[n] = dArray[n] + (mt.m00 + m * y * y + z * z);
            double[] dArray2 = tensor[Y];
            int n2 = Y;
            dArray2[n2] = dArray2[n2] + (mt.m11 + m * x * x + z * z);
            double[] dArray3 = tensor[Z];
            int n3 = Z;
            dArray3[n3] = dArray3[n3] + (mt.m22 + m * x * x + y * y);
            double xy = -(m * x * y);
            double yz = -(m * y * z);
            double zx = -(m * z * x);
            double[] dArray4 = tensor[X];
            int n4 = Y;
            dArray4[n4] = dArray4[n4] + xy;
            double[] dArray5 = tensor[Y];
            int n5 = X;
            dArray5[n5] = dArray5[n5] + xy;
            double[] dArray6 = tensor[Y];
            int n6 = Z;
            dArray6[n6] = dArray6[n6] + yz;
            double[] dArray7 = tensor[Z];
            int n7 = Y;
            dArray7[n7] = dArray7[n7] + yz;
            double[] dArray8 = tensor[Z];
            int n8 = X;
            dArray8[n8] = dArray8[n8] + zx;
            double[] dArray9 = tensor[X];
            int n9 = Z;
            dArray9[n9] = dArray9[n9] + zx;
            double dist = Math.sqrt(x * x + y * y + z * z) + bodyMass.getRadius();
            if (!(dist > radius)) continue;
            radius = dist;
        }
        Matrix3d inertiaTensor = new Matrix3d(tensor[0][0], tensor[0][1], tensor[0][2], tensor[1][0], tensor[1][1], tensor[1][2], tensor[2][0], tensor[2][1], tensor[2][2]);
        Matrix3d inverseInertiaTensor = inertiaTensor.invert();
        return new BodyMass(1.0 / totalMass, inverseInertiaTensor, center, radius);
    }

    public static BodyMass calculateBodyMass(CellArray cells, double scale, double mass) {
        double totalMass = 0.0;
        Vec3d center = new Vec3d();
        int xSize = cells.getSizeX();
        int ySize = cells.getSizeY();
        int zSize = cells.getSizeZ();
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int value = cells.getCell(i, j, k);
                    int type = MaskUtils.getType((int)value);
                    double m = MassUtils.getMass(type);
                    totalMass += m;
                    center.addLocal(((double)i + 0.5) * scale * m, ((double)j + 0.5) * scale * m, ((double)k + 0.5) * scale * m);
                }
            }
        }
        if (totalMass == 0.0) {
            return null;
        }
        center.multLocal(1.0 / totalMass);
        double massScale = 1.0;
        if (mass > 0.0) {
            massScale = mass / totalMass;
        }
        double[][] tensor = new double[3][3];
        int X = 0;
        int Y = 1;
        int Z = 2;
        double radiusSq = 0.0;
        double totalPointMass = 0.0;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                for (int k = 0; k < zSize; ++k) {
                    int value = cells.getCell(i, j, k);
                    int type = MaskUtils.getType((int)value);
                    double m = MassUtils.getMass(type) * massScale;
                    totalPointMass += m;
                    double g = m * 1.0 / 6.0;
                    double x = ((double)i + 0.5) * scale - center.x;
                    double y = ((double)j + 0.5) * scale - center.y;
                    double z = ((double)k + 0.5) * scale - center.z;
                    double[] dArray = tensor[X];
                    int n = X;
                    dArray[n] = dArray[n] + (g + m * y * y + z * z);
                    double[] dArray2 = tensor[Y];
                    int n2 = Y;
                    dArray2[n2] = dArray2[n2] + (g + m * x * x + z * z);
                    double[] dArray3 = tensor[Z];
                    int n3 = Z;
                    dArray3[n3] = dArray3[n3] + (g + m * x * x + y * y);
                    double xy = -(m * x * y);
                    double yz = -(m * y * z);
                    double zx = -(m * z * x);
                    double[] dArray4 = tensor[X];
                    int n4 = Y;
                    dArray4[n4] = dArray4[n4] + xy;
                    double[] dArray5 = tensor[Y];
                    int n5 = X;
                    dArray5[n5] = dArray5[n5] + xy;
                    double[] dArray6 = tensor[Y];
                    int n6 = Z;
                    dArray6[n6] = dArray6[n6] + yz;
                    double[] dArray7 = tensor[Z];
                    int n7 = Y;
                    dArray7[n7] = dArray7[n7] + yz;
                    double[] dArray8 = tensor[Z];
                    int n8 = X;
                    dArray8[n8] = dArray8[n8] + zx;
                    double[] dArray9 = tensor[X];
                    int n9 = Z;
                    dArray9[n9] = dArray9[n9] + zx;
                    double dSq = (x = Math.abs(x) + 0.5 * scale) * x + (y = Math.abs(y) + 0.5 * scale) * y + (z = Math.abs(z) + 0.5 * scale) * z;
                    if (!(dSq > radiusSq)) continue;
                    radiusSq = dSq;
                }
            }
        }
        Matrix3d inertiaTensor = new Matrix3d(tensor[0][0], tensor[0][1], tensor[0][2], tensor[1][0], tensor[1][1], tensor[1][2], tensor[2][0], tensor[2][1], tensor[2][2]);
        Matrix3d inverseInertiaTensor = inertiaTensor.invert();
        if (mass <= 0.0) {
            mass = totalMass;
        }
        return new BodyMass(1.0 / mass, inverseInertiaTensor, center, Math.sqrt(radiusSq));
    }
}

