/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys;

import com.google.common.base.MoreObjects;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.QueryVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Frustum
implements QueryVolume {
    static Logger log = LoggerFactory.getLogger(Frustum.class);
    private Vec3d position;
    private Quatd orientation;
    private double far;
    private double xFov;
    private double yFov;
    private Vec3d xTrig = new Vec3d();
    private Vec3d yTrig = new Vec3d();
    private Vec3d dir;
    private Vec3d left;
    private Vec3d up;

    public Frustum(double far, double xFov, double yFov) {
        this(new Vec3d(), new Quatd(), far, xFov, yFov);
    }

    public Frustum(Vec3d position, Quatd orientation, double far, double xFov, double yFov) {
        this.position = position;
        this.orientation = orientation;
        this.far = far;
        this.xFov = xFov;
        this.yFov = yFov;
        this.recalculateXTrig();
        this.recalculateYTrig();
    }

    public void set(Vec3d position, Quatd orientation) {
        this.setPosition(position);
        this.setOrientation(orientation);
    }

    protected final void recalculateXTrig() {
        double half = this.xFov * 0.5;
        this.xTrig.x = Math.cos(half);
        this.xTrig.y = Math.sin(half);
        this.xTrig.z = Math.tan(half);
    }

    protected final void recalculateYTrig() {
        double half = this.yFov * 0.5;
        this.yTrig.x = Math.cos(half);
        this.yTrig.y = Math.sin(half);
        this.yTrig.z = Math.tan(half);
    }

    public void setPosition(Vec3d position) {
        this.position.set(position);
    }

    public Vec3d getPosition() {
        return this.position;
    }

    public void setOrientation(Quatd orientation) {
        this.orientation.set(orientation);
        this.dir = null;
        this.left = null;
        this.up = null;
    }

    public Quatd getOrientation() {
        return this.orientation;
    }

    public void setFar(double far) {
        this.far = far;
    }

    public double getFar() {
        return this.far;
    }

    public void setHorizontalFov(double xFov) {
        this.xFov = xFov;
        this.recalculateXTrig();
    }

    public double getHorizontalFov() {
        return this.xFov;
    }

    public void setVerticalFov(double yFov) {
        this.yFov = yFov;
        this.recalculateYTrig();
    }

    public double getVerticalFov() {
        return this.yFov;
    }

    public final Vec3d getDir() {
        if (this.dir == null) {
            this.dir = this.orientation.mult(Vec3d.UNIT_Z);
        }
        return this.dir;
    }

    public final Vec3d getLeft() {
        if (this.left == null) {
            this.left = this.orientation.mult(Vec3d.UNIT_X);
        }
        return this.left;
    }

    public final Vec3d getUp() {
        if (this.up == null) {
            this.up = this.orientation.mult(Vec3d.UNIT_Y);
        }
        return this.up;
    }

    @Override
    public boolean intersects(Vec3d pos, double radius) {
        return this.toFrustumSpace(pos, radius, null) != null;
    }

    public Vec3d toFrustumSpace(Vec3d pos, double radius, Vec3d target) {
        if (target == null) {
            target = new Vec3d();
        }
        target.set(pos).subtractLocal(this.position);
        double z = target.dot(this.getDir());
        if (z + radius < 0.0) {
            return null;
        }
        if (z - radius > this.far) {
            return null;
        }
        double zRadius = this.xTrig.y * radius;
        double xRadius = this.xTrig.x * radius;
        double xAtZ = this.xTrig.z * (z + zRadius);
        double x = target.dot(this.getLeft());
        if (x > 0.0 ? x - xRadius > xAtZ : x + xRadius < -xAtZ) {
            return null;
        }
        zRadius = this.yTrig.y * radius;
        double yRadius = this.yTrig.x * radius;
        double yAtZ = this.yTrig.z * (z + zRadius);
        double y = target.dot(this.getUp());
        if (y > 0.0 ? y - yRadius > yAtZ : y + yRadius < -yAtZ) {
            return null;
        }
        target.set(x, y, z);
        return target;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("position", (Object)this.position).add("orientation", (Object)this.orientation).add("far", this.far).add("xFov", this.xFov).add("yFov", this.yFov).toString();
    }
}

