/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mphys.simple;

import com.google.common.base.Predicate;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.CollisionSystem;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.ContactListener;
import com.simsilica.mphys.HitResults;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.StaticBody;
import com.simsilica.mphys.simple.SimpleShape;

public class SimpleCollisionSystem<K>
implements CollisionSystem<K, SimpleShape> {
    private double restitution = 0.1;
    private double friction = 0.7;

    public void setRestitution(double restitution) {
        this.restitution = restitution;
    }

    public double getRestitution() {
        return this.restitution;
    }

    public void setFriction(double friction) {
        this.friction = friction;
    }

    public double getFriction() {
        return this.friction;
    }

    @Override
    public void generateWorldCollisions(RigidBody<K, SimpleShape> body, ContactListener<K, SimpleShape> results) {
        double radius = ((SimpleShape)body.shape).getMass().getRadius();
        Vec3d pos = body.position;
        if (pos.y < radius) {
            Vec3d cp = new Vec3d(pos.x, 0.0, pos.z);
            Vec3d cn = new Vec3d(0.0, 1.0, 0.0);
            double penetration = radius - pos.y;
            Contact<K, SimpleShape> contact = new Contact<K, SimpleShape>(body, cp, cn, penetration);
            contact.restitution = this.restitution;
            contact.friction = this.friction;
            results.newContact(contact);
        }
    }

    private static Vec3d toNormal(Vec3d delta, double dist) {
        if (dist > 0.0) {
            return delta.mult(1.0 / dist);
        }
        System.out.println("Random deflect.");
        delta.x = Math.random() * 0.1;
        delta.y = Math.random() * 0.1;
        delta.z = Math.random() * 0.1;
        return delta.normalizeLocal();
    }

    private static Vec3d toNormal(Vec3d delta, double dist, Vec3d fallback) {
        if (dist > 0.0) {
            return delta.mult(1.0 / dist);
        }
        if (fallback.lengthSq() == 1.0) {
            return fallback;
        }
        return SimpleCollisionSystem.toNormal(fallback, fallback.length());
    }

    private void checkStaticContact(RigidBody<K, SimpleShape> body, StaticBody<K, SimpleShape> world, ContactListener<K, SimpleShape> results) {
        double r1 = ((SimpleShape)body.shape).getMass().getRadius();
        double r2 = ((SimpleShape)world.shape).getMass().getRadius();
        if (((SimpleShape)world.shape).getType() == SimpleShape.Type.Sphere) {
            Vec3d cp;
            double threshold = (r1 + r2) * (r1 + r2);
            double distSq = body.position.distanceSq(world.position);
            if (distSq > threshold) {
                return;
            }
            double dist = Math.sqrt(distSq);
            if (dist > 0.0) {
                Vec3d delta = body.position.subtract(world.position);
                cp = delta.multLocal(r2 / dist).addLocal(world.position);
            } else {
                cp = world.position.clone();
            }
            if (!(dist > 0.0)) {
                System.out.println("Static sphere coincidence body:" + body.position + "  sphere:" + world.position + "  dist:" + dist);
            }
            Vec3d cn = SimpleCollisionSystem.toNormal(body.position.subtract(world.position), dist);
            double penetration = r1 - (dist - r2);
            Contact<K, SimpleShape> contact = new Contact<K, SimpleShape>(body, world, cp, cn, penetration);
            contact.restitution = this.restitution;
            contact.friction = this.friction;
            results.newContact(contact);
        } else {
            double penetration;
            double x = body.position.x - world.position.x;
            double y = body.position.y - world.position.y;
            double z = body.position.z - world.position.z;
            Vec3d cn = new Vec3d();
            int edgeOrFaceHit = 0;
            if (x > r2) {
                x = r2;
                cn.x = 1.0;
            } else if (x < -r2) {
                x = -r2;
                cn.x = -1.0;
            } else {
                cn.x = 0.0;
                ++edgeOrFaceHit;
            }
            if (y > r2) {
                y = r2;
                cn.y = 1.0;
            } else if (y < -r2) {
                y = -r2;
                cn.y = -1.0;
            } else {
                cn.y = 0.0;
                ++edgeOrFaceHit;
            }
            if (z > r2) {
                z = r2;
                cn.z = 1.0;
            } else if (z < -r2) {
                z = -r2;
                cn.z = -1.0;
            } else {
                cn.z = 0.0;
                ++edgeOrFaceHit;
            }
            Vec3d cp = world.position.add(x, y, z);
            if (edgeOrFaceHit > 2) {
                Vec3d delta;
                double dist;
                if (edgeOrFaceHit == 3) {
                    System.out.println("Inside. cn:" + cn + "  edgeOrFaceHit:" + edgeOrFaceHit + "  body:" + body.position + "  static:" + world.position);
                    if (x > y) {
                        if (x > z) {
                            cn.x = 1.0;
                        } else {
                            cn.z = 1.0;
                        }
                    } else if (y > z) {
                        cn.y = 1.0;
                    } else {
                        cn.z = 1.0;
                    }
                }
                if ((dist = cn.dot(delta = body.position.subtract(world.position))) > r1 + r2) {
                    return;
                }
                penetration = r1 - (dist - r2);
            } else {
                double distSq = cp.distanceSq(body.position);
                if (distSq > r1 * r1) {
                    return;
                }
                double dist = Math.sqrt(distSq);
                if (dist > 0.0) {
                    cn = body.position.subtract(cp).mult(1.0 / dist);
                } else {
                    Vec3d delta = body.position.subtract(world.position);
                    System.out.println("Deflect. cn:" + cn + "  edgeOrFaceHit:" + edgeOrFaceHit + "  body:" + body.position + "  static:" + world.position);
                    cn = SimpleCollisionSystem.toNormal(delta, delta.length());
                }
                penetration = r1 - dist;
            }
            Contact<K, SimpleShape> contact = new Contact<K, SimpleShape>(body, world, cp, cn, penetration);
            contact.restitution = this.restitution;
            contact.friction = this.friction;
            results.newContact(contact);
        }
    }

    @Override
    public void generateStaticCollisions(RigidBody<K, SimpleShape> body, StaticBody<K, SimpleShape>[] staticObjects, ContactListener<K, SimpleShape> results) {
        for (StaticBody<K, SimpleShape> world : staticObjects) {
            this.checkStaticContact(body, world, results);
        }
    }

    @Override
    public void generateBodyCollisions(RigidBody<K, SimpleShape> body, RigidBody<K, SimpleShape>[] inactiveObjects, ContactListener<K, SimpleShape> results) {
        for (RigidBody<K, SimpleShape> sleeper : inactiveObjects) {
            this.checkContact(body, sleeper, results);
        }
    }

    @Override
    public void generateBodyCollisions(RigidBody<K, SimpleShape>[] bodies, ContactListener<K, SimpleShape> results) {
        for (int i = 0; i < bodies.length; ++i) {
            RigidBody<K, SimpleShape> b1 = bodies[i];
            for (int j = i + 1; j < bodies.length; ++j) {
                RigidBody<K, SimpleShape> b2 = bodies[j];
                this.checkContact(b1, b2, results);
            }
        }
    }

    @Override
    public void generateStaticCollisions(RigidBody<K, SimpleShape> body, StaticBody<K, SimpleShape>[] staticObjects, Predicate<? super StaticBody<K, SimpleShape>> bodyFilter, ContactListener<K, SimpleShape> results) {
        for (StaticBody<K, SimpleShape> world : staticObjects) {
            if (!bodyFilter.apply(world)) continue;
            this.checkStaticContact(body, world, results);
        }
    }

    @Override
    public void generateBodyCollisions(RigidBody<K, SimpleShape> body, RigidBody<K, SimpleShape>[] inactiveObjects, Predicate<? super RigidBody<K, SimpleShape>> bodyFilter, ContactListener<K, SimpleShape> results) {
        for (RigidBody<K, SimpleShape> sleeper : inactiveObjects) {
            if (!bodyFilter.apply(sleeper)) continue;
            this.checkContact(body, sleeper, results);
        }
    }

    protected void checkContact(RigidBody<K, SimpleShape> b1, RigidBody<K, SimpleShape> b2, ContactListener<K, SimpleShape> results) {
        Vec3d cp;
        double r1 = ((SimpleShape)b1.shape).getMass().getRadius();
        double r2 = ((SimpleShape)b2.shape).getMass().getRadius();
        double threshold = (r1 + r2) * (r1 + r2);
        double distSq = b1.position.distanceSq(b2.position);
        if (distSq > threshold) {
            return;
        }
        double dist = Math.sqrt(distSq);
        if (dist > 0.0) {
            Vec3d delta = b1.position.subtract(b2.position);
            cp = delta.multLocal(r2 / dist).addLocal(b2.position);
        } else {
            cp = b1.position.clone();
        }
        Vec3d cn = SimpleCollisionSystem.toNormal(b1.position.subtract(b2.position), dist);
        double penetration = r1 - (dist - r2);
        Contact<K, SimpleShape> contact = new Contact<K, SimpleShape>(b1, b2, cp, cn, penetration);
        contact.restitution = this.restitution;
        contact.friction = this.friction;
        results.newContact(contact);
    }

    @Override
    public void queryBodyHits(Rayd ray, RigidBody<K, SimpleShape>[] bodies, HitResults<K, SimpleShape> hits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void queryStaticHits(Rayd ray, StaticBody<K, SimpleShape>[] staticObjects, HitResults<K, SimpleShape> hits) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void queryWorldHits(Rayd ray, HitResults<K, SimpleShape> hits) {
        throw new UnsupportedOperationException();
    }
}

