/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.google.common.io.Resources;
import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.style.ElementId;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mythruna.GameConstants;
import mythruna.client.GuiState;
import mythruna.client.MythrunaConfig;
import mythruna.client.ui.MarkdownUtil;
import mythruna.text.MultipartText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhatsNewState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(WhatsNewState.class);
    private static final String LAST_LOOK_KEY = WhatsNewState.class.getSimpleName() + ".lastLook";
    private Container window;
    private List<Container> pages = new ArrayList<Container>();
    private int currentPage = 0;
    private ActionButton previous;
    private ActionButton next;
    private float maxWidth = 600.0f;
    private String version = GameConstants.buildVersion();

    public WhatsNewState() {
        String lastLook = MythrunaConfig.getInstance().getStartupSetting(LAST_LOOK_KEY, "00000000");
        log.info("version:" + this.version + " lastLook:" + lastLook);
        this.setEnabled(this.version.compareTo(lastLook) > 0);
    }

    protected void olderVersion() {
        this.setCurrentPage(this.currentPage + 1);
    }

    protected void newerVersion() {
        this.setCurrentPage(this.currentPage - 1);
    }

    protected void close() {
        this.setEnabled(false);
        MythrunaConfig.getInstance().getStartupSettings().put(LAST_LOOK_KEY, this.version);
        MythrunaConfig.getInstance();
        MythrunaConfig.save();
    }

    protected void initialize(Application app) {
        String text = this.loadText();
        Map parts = MultipartText.parseParts((String)text);
        TreeMap sorted = new TreeMap(parts);
        for (Map.Entry e : sorted.entrySet()) {
            Container page = MarkdownUtil.createContainer(new ElementId("book.page"));
            MarkdownUtil.populateContainer(page, this.maxWidth, (String)e.getValue());
            this.pages.add(0, page);
        }
        ElementId base = new ElementId("dialog.window");
        this.window = new Container((GuiLayout)new BorderLayout(), base.child("container"));
        this.window.setInsets(new Insets3f(5.0f, 5.0f, 5.0f, 5.0f));
        this.window.setBorder((GuiComponent)new QuadBackgroundComponent(new ColorRGBA(0.01f, 0.1f, 0.01f, 0.9f)));
        Container buttons = (Container)this.window.addChild((Node)new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y)), new Object[]{BorderLayout.Position.South});
        buttons.setInsets(new Insets3f(20.0f, 2.0f, 2.0f, 2.0f));
        this.next = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "newerVersion")), new Object[0]);
        this.previous = (ActionButton)buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "olderVersion")), new Object[0]);
        buttons.addChild((Node)new ActionButton((Action)new CallMethodAction((Object)this, "close")), new Object[0]);
        this.updatePage();
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        this.getApplication().enqueue(() -> {
            this.resetPosition();
            this.window.updateLogicalState(0.01f);
            GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.window, new ColorRGBA(0.0f, 0.0f, 0.0f, 0.15f));
        });
    }

    protected void onDisable() {
        this.window.removeFromParent();
    }

    public void update(float tpf) {
    }

    protected void setCurrentPage(int page) {
        if (page < 0) {
            page = 0;
        }
        if (page >= this.pages.size()) {
            page = this.pages.size() - 1;
        }
        if (this.currentPage == page) {
            return;
        }
        this.currentPage = page;
        this.updatePage();
    }

    protected void updatePage() {
        this.window.addChild((Node)this.pages.get(this.currentPage), new Object[]{BorderLayout.Position.Center});
        this.updateButtonState();
    }

    protected void updateButtonState() {
        if (this.currentPage > 0) {
            this.next.setEnabled(true);
            this.next.setCullHint(Spatial.CullHint.Inherit);
        } else {
            this.next.setEnabled(false);
            this.next.setCullHint(Spatial.CullHint.Always);
        }
        if (this.currentPage < this.pages.size() - 1) {
            this.previous.setEnabled(true);
            this.previous.setCullHint(Spatial.CullHint.Inherit);
        } else {
            this.previous.setEnabled(false);
            this.previous.setCullHint(Spatial.CullHint.Always);
        }
    }

    protected void resetPosition() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.window);
    }

    protected String loadText() {
        URL u = ((Object)((Object)this)).getClass().getResource("/text-db/docs/release-notes.txt");
        if (u == null) {
            return "release-notes.txt not found";
        }
        try {
            return Resources.toString((URL)u, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Error reading:" + u, (Throwable)e);
            return "Error reading release-notes.txt\nSee log for details.";
        }
    }
}

