/*
 * Decompiled with CFR 0.152.
 */
package mythruna.assembly;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.clone.Cloner;
import java.util.ArrayList;
import java.util.List;
import mythruna.assembly.Joint;
import mythruna.assembly.JointController;
import mythruna.assembly.SpatialJointController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixControl
extends AbstractControl {
    static Logger log = LoggerFactory.getLogger(MixControl.class);
    private List<SpatialJointController> controllers = new ArrayList<SpatialJointController>();

    public boolean hasJoints() {
        return !this.controllers.isEmpty();
    }

    public void setMix(String verb, double mix) {
        for (JointController jointController : this.controllers) {
            if (!jointController.matchesVerb(verb)) continue;
            jointController.setMix(mix);
        }
    }

    public void addJoint(Joint joint, Spatial target) {
        this.addController(new SpatialJointController(joint, target));
    }

    public void addController(SpatialJointController controller) {
        this.controllers.add(controller);
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    protected void controlUpdate(float tpf) {
    }

    public void cloneFields(Cloner cloner, Object rawOriginal) {
        super.cloneFields(cloner, rawOriginal);
        MixControl original = (MixControl)((Object)rawOriginal);
        this.controllers = new ArrayList<SpatialJointController>();
        for (SpatialJointController controller : original.controllers) {
            Spatial s = (Spatial)cloner.clone((Object)((Spatial)controller.getTarget()));
            this.addJoint(controller.getJoint(), s);
        }
    }
}

