/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.simsilica.ext.mphys.Mass;
import com.simsilica.ext.mphys.ShapeFactory;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.mblock.phys.MBlockShape;
import java.util.function.Function;
import mythruna.shape.ShapeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricShapeFactory
implements ShapeFactory<MBlockShape> {
    static Logger log = LoggerFactory.getLogger(FabricShapeFactory.class);
    private static final CellArray BOX = new CellArray(1);
    private Function<CellArrayId, CellArray> storage;

    public FabricShapeFactory(Function<CellArrayId, CellArray> storage) {
        this.storage = storage;
    }

    public MBlockShape createShape(String name, double scale, Mass mass) {
        ShapeName shape;
        if (log.isTraceEnabled()) {
            log.trace("createShape(" + name + ", " + scale + ", " + mass + ")");
        }
        if (!"fab".equals((shape = ShapeName.parse(name)).getType())) {
            return null;
        }
        double m = mass == null ? 0.0 : mass.getMass();
        CellArray cells = BOX;
        return MBlockShape.createShape((String)name, (CellArray)cells, (double)scale, (double)m);
    }

    static {
        BOX.setCell(0, 0, 0, MaskUtils.setSideMask((int)1, (int)63));
    }
}

