/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnGenerationListener;
import com.simsilica.util.CacheTracker;

public class CachedColumnDb
implements ColumnDb {
    private final ColumnDb delegate;
    private LoadingCache<ColumnId, ColumnData> cache;

    public CachedColumnDb(final ColumnDb delegate, int cacheSize) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).recordStats().build((CacheLoader)new CacheLoader<ColumnId, ColumnData>(){

            public ColumnData load(ColumnId key) {
                return delegate.getColumn(key);
            }
        });
        CacheTracker.track(this.cache, (String)("CachedColumnDb@" + System.identityHashCode(this)), (boolean)true);
    }

    @Override
    public void initialize() {
        this.delegate.initialize();
    }

    @Override
    public void terminate() {
        this.delegate.terminate();
    }

    @Override
    public ColumnData getColumn(ColumnId columnId) {
        return (ColumnData)this.cache.getUnchecked((Object)columnId);
    }

    @Override
    public void markChanged(ColumnData col) {
        this.delegate.markChanged(col);
    }

    @Override
    public void setGenerationHook(ColumnGenerationListener l) {
        this.delegate.setGenerationHook(l);
    }

    @Override
    public ColumnGenerationListener getGenerationHook() {
        return this.delegate.getGenerationHook();
    }
}

