/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.opengl;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import mythruna.client.opengl.DisplayModeProvider;
import mythruna.client.opengl.DisplaySettings;
import mythruna.client.opengl.ModeInfo;
import mythruna.client.opengl.Resolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicDisplaySettingsPanel
extends JPanel {
    static Logger log = LoggerFactory.getLogger(BasicDisplaySettingsPanel.class);
    private DisplayModeProvider provider;
    private ListMultimap<Resolution, ModeInfo> fullscreenResolutions = MultimapBuilder.treeKeys().arrayListValues().build();
    private ListMultimap<Resolution, ModeInfo> windowResolutions = MultimapBuilder.treeKeys().arrayListValues().build();
    private JCheckBox fullScreen;
    private JComboBox<Resolution> resolution;
    private JComboBox<MsaaSampleSize> msaa;
    private DefaultComboBoxModel<Resolution> resolutionModel;
    private DefaultComboBoxModel<MsaaSampleSize> sampleModel;
    private boolean showFullScreenResolutions;
    private Collection<Runnable> repaintListeners = new ArrayList<Runnable>();
    private DisplaySettings settings = new DisplaySettings();

    public BasicDisplaySettingsPanel(DisplayModeProvider provider, Font font) {
        this.provider = provider;
        ModeInfo current = provider.getCurrentDisplayMode();
        for (ModeInfo mode : provider.getDisplayModes()) {
            Resolution resolution = mode.getResolution();
            if (mode.isFullscreen()) {
                this.fullscreenResolutions.put((Object)resolution, (Object)mode);
                continue;
            }
            this.windowResolutions.put((Object)resolution, (Object)mode);
        }
        log.info("Fullscreen:");
        for (Resolution resolution : this.fullscreenResolutions.keySet()) {
            log.info("  " + resolution + " (" + resolution.aspectRatioToString() + ")");
            for (ModeInfo mode : this.fullscreenResolutions.get((Object)resolution)) {
                log.info("    depth:" + mode.getBitsPerPixel() + " frequency:" + mode.getFrequency());
            }
        }
        log.info("Windowed:");
        for (Resolution resolution : this.windowResolutions.keySet()) {
            log.info("  " + resolution + " (" + resolution.aspectRatioToString() + ")");
        }
        log.info("current:" + current);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.anchor = 17;
        this.fullScreen = new JCheckBox("Full Screen");
        this.fullScreen.setFont(font);
        this.fullScreen.setBackground(new Color(0, 0, 0, 0));
        this.fullScreen.addChangeListener(this::fullScreenChanged);
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.fullScreen, gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        JLabel label = new JLabel("Screen Resolution:");
        label.setFont(font);
        this.add((Component)label, gbc);
        PopupMenuListener refresher = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.refresh();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.refresh();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            protected void refresh() {
                BasicDisplaySettingsPanel.this.fireRepaint();
            }
        };
        ++gbc.gridx;
        this.resolution = new JComboBox();
        this.resolution.setFont(font);
        this.resolution.setOpaque(false);
        this.resolution.addItemListener(this::resolutionChanged);
        this.resolution.addPopupMenuListener(refresher);
        this.add(this.resolution, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        label = new JLabel("Multi-sampling:");
        label.setFont(font);
        String msaaHelp = "Number of anti-aliasing multi-samples.";
        label.setToolTipText(msaaHelp);
        this.add((Component)label, gbc);
        ++gbc.gridx;
        this.sampleModel = new DefaultComboBoxModel<MsaaSampleSize>(MsaaSampleSize.values());
        this.msaa = new JComboBox<MsaaSampleSize>(this.sampleModel);
        this.msaa.setFont(font);
        this.msaa.setOpaque(false);
        this.msaa.addItemListener(this::msaaChanged);
        this.msaa.addPopupMenuListener(refresher);
        this.msaa.setToolTipText(msaaHelp);
        this.add(this.msaa, gbc);
        this.setShowFullScreenResolutions(this.fullScreen.isSelected());
        this.updateResolutions();
        this.updateCurrentMode();
    }

    public void addRepaintListener(Runnable r) {
        this.repaintListeners.add(r);
    }

    public void removeRepaintListener(Runnable r) {
        this.repaintListeners.remove(r);
    }

    public void setFullScreen(boolean fullScreen) {
        log.info("setFullScreen(" + fullScreen + ")");
        this.fullScreen.setSelected(fullScreen);
    }

    public boolean isFullScreen() {
        return this.fullScreen.isSelected();
    }

    public void setResolution(Resolution res) {
        log.info("setResolution(" + res + ")  valid:" + this.getCurrentResolutions().contains(res));
        if (!this.getCurrentResolutions().contains(res)) {
            return;
        }
        this.resolution.setSelectedItem(res);
    }

    public Resolution getResolution() {
        return (Resolution)this.resolution.getSelectedItem();
    }

    public void setCurrentMode(ModeInfo mode) {
        log.info("setCurrentMode(" + mode + ")");
        if (mode == null) {
            return;
        }
        this.setFullScreen(mode.isFullscreen());
        this.setResolution(mode.getResolution());
    }

    public void setDisplaySettings(DisplaySettings settings) {
        if (settings == null) {
            return;
        }
        this.settings.set(settings);
        this.setFullScreen(settings.getMode().isFullscreen());
        this.setResolution(settings.getMode().getResolution());
        MsaaSampleSize size = MsaaSampleSize.findMsaaSamples(settings.getMsaaSamples());
        if (size != null) {
            this.msaa.setSelectedItem((Object)size);
        }
    }

    public DisplaySettings getDisplaySettings() {
        return this.settings;
    }

    protected void fireRepaint() {
        for (Runnable r : this.repaintListeners) {
            r.run();
        }
    }

    protected void fullScreenChanged(ChangeEvent event) {
        this.setShowFullScreenResolutions(this.fullScreen.isSelected());
    }

    protected void setShowFullScreenResolutions(boolean showFullScreenResolutions) {
        if (this.showFullScreenResolutions == showFullScreenResolutions) {
            return;
        }
        this.showFullScreenResolutions = showFullScreenResolutions;
        this.updateResolutions();
        this.updateCurrentMode();
    }

    protected ListMultimap<Resolution, ModeInfo> getCurrentModes() {
        if (this.showFullScreenResolutions) {
            return this.fullscreenResolutions;
        }
        return this.windowResolutions;
    }

    protected Collection<Resolution> getCurrentResolutions() {
        if (this.showFullScreenResolutions) {
            return this.fullscreenResolutions.keySet();
        }
        return this.windowResolutions.keySet();
    }

    protected void updateResolutions() {
        Resolution selected = (Resolution)this.resolution.getSelectedItem();
        this.resolutionModel = this.showFullScreenResolutions ? new DefaultComboBoxModel<Resolution>(this.fullscreenResolutions.keySet().toArray(new Resolution[0])) : new DefaultComboBoxModel<Resolution>(this.windowResolutions.keySet().toArray(new Resolution[0]));
        this.resolution.setModel(this.resolutionModel);
        this.resolution.setSelectedItem(selected);
    }

    protected void resolutionChanged(ItemEvent event) {
        this.updateCurrentMode();
    }

    protected void msaaChanged(ItemEvent event) {
        log.info("msaaChanged(" + event + ")");
        MsaaSampleSize size = (MsaaSampleSize)((Object)this.msaa.getSelectedItem());
        if (size != null) {
            this.settings.setMsaaSamples(size.getValue());
        }
    }

    protected ModeInfo findCompatibleMode(Resolution resolution, ModeInfo find) {
        for (ModeInfo mode : this.getCurrentModes().get((Object)resolution)) {
            if (mode.getBitsPerPixel() != find.getBitsPerPixel() || Math.abs(mode.getFrequency() - find.getFrequency()) >= 2) continue;
            return mode;
        }
        return null;
    }

    protected void updateCurrentMode() {
        Resolution selected = (Resolution)this.resolution.getSelectedItem();
        if (selected == null) {
            return;
        }
        ModeInfo found = this.findCompatibleMode(selected, this.provider.getScreenDisplayMode());
        if (found != null) {
            this.settings.setMode(found);
            log.info("New mode:" + this.settings.getMode());
        } else {
            log.warn("Couldn't find mode compatible with:" + this.provider.getScreenDisplayMode());
        }
    }

    public void addResolutionChangeListener(ItemListener listener) {
        this.resolution.addItemListener(listener);
    }

    public void removeResolutionChangeListener(ItemListener listener) {
        this.resolution.removeItemListener(listener);
    }

    private static enum MsaaSampleSize {
        Disabled("Disabled", 0),
        X2("x2", 2),
        X4("x4", 4),
        X8("x8", 8),
        X16("x16", 16);

        private String name;
        private int value;

        private MsaaSampleSize(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static MsaaSampleSize findMsaaSamples(int value) {
            for (MsaaSampleSize size : MsaaSampleSize.values()) {
                if (size.value != value) continue;
                return size;
            }
            return null;
        }
    }
}

