/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.ui.clothing;

import com.simsilica.mathd.Vec3i;
import java.util.function.Supplier;
import mythruna.fabric.ClothingAccumulator;
import mythruna.fabric.FabricUtils;
import mythruna.fabric.SwatchShapeIndex;
import mythruna.fabric.Transform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HatMirrorTransform
implements ClothingAccumulator {
    static Logger log = LoggerFactory.getLogger(HatMirrorTransform.class);
    private ClothingAccumulator delegate;
    private Supplier<Boolean> on;

    public HatMirrorTransform(ClothingAccumulator delegate, Supplier<Boolean> on) {
        this.delegate = delegate;
        this.on = on;
    }

    public int getSizeX() {
        return this.delegate.getSizeX();
    }

    public int getSizeY() {
        return this.delegate.getSizeY();
    }

    public int getValue(int x, int y, int layer) {
        return this.delegate.getValue(x, y, layer);
    }

    public int getTopValue(int x, int y) {
        return this.delegate.getTopValue(x, y);
    }

    public int getLayer(int x, int y) {
        return this.delegate.getLayer(x, y);
    }

    public int addValue(int x, int y, int value) {
        int result = this.delegate.addValue(x, y, value);
        Vec3i alt = this.getAlternate(x, y);
        log.info("addValue(" + x + ", " + y + ", " + value + ") alt:" + alt);
        if (alt != null) {
            this.delegate.addValue(alt.x, alt.y, this.getTransform(value));
        }
        return result;
    }

    public int insertValue(int x, int y, int value) {
        int result = this.delegate.insertValue(x, y, value);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.insertValue(alt.x, alt.y, this.getTransform(value));
        }
        return result;
    }

    public int removeSwatch(int x, int y) {
        int result = this.delegate.removeSwatch(x, y);
        Vec3i alt = this.getAlternate(x, y);
        log.info("removeSwatch(" + x + ", " + y + ") alt:" + alt);
        if (alt != null) {
            this.delegate.removeSwatch(alt.x, alt.y);
        }
        return result;
    }

    public int deleteValue(int x, int y) {
        int result = this.delegate.deleteValue(x, y);
        Vec3i alt = this.getAlternate(x, y);
        if (alt != null) {
            this.delegate.deleteValue(alt.x, alt.y);
        }
        return result;
    }

    protected Vec3i getAlternate(int x, int y) {
        int offset;
        if (!this.on.get().booleanValue()) {
            return null;
        }
        if (x <= 2) {
            return new Vec3i(6 - x, y, 0);
        }
        if (x >= 4 && x <= 6) {
            int offset2 = x - 4;
            return new Vec3i(2 - offset2, y, 0);
        }
        if (x >= 8 && x <= 11) {
            offset = x - 8;
            if (y <= 7) {
                return new Vec3i(11 - offset, y + 9, 0);
            }
            if (y >= 9 && y <= 16) {
                return new Vec3i(11 - offset, y - 9, 0);
            }
            if (y >= 18 && y <= 20) {
                return new Vec3i(11 - offset, y + 4, 0);
            }
            if (y >= 22 && y <= 24) {
                return new Vec3i(11 - offset, y - 4, 0);
            }
        }
        if (y <= 7) {
            if (x >= 13 && x <= 15) {
                offset = x - 13;
                return new Vec3i(19 - offset, y, 0);
            }
            if (x >= 17 && x <= 19) {
                offset = x - 17;
                return new Vec3i(15 - offset, y, 0);
            }
        }
        if (y >= 9 && y <= 15) {
            if (x >= 12 && x <= 17) {
                offset = x - 12;
                return new Vec3i(24 - offset, y, 0);
            }
            if (x >= 19 && x <= 24) {
                offset = x - 19;
                return new Vec3i(17 - offset, y, 0);
            }
        }
        if (y <= 6) {
            if (x >= 20 && x <= 24) {
                offset = x - 20;
                return new Vec3i(30 - offset, y, 0);
            }
            if (x >= 26 && x <= 30) {
                offset = x - 26;
                return new Vec3i(24 - offset, y, 0);
            }
        }
        return null;
    }

    protected int getTransform(int value) {
        int fabric = FabricUtils.toFabric((int)value);
        int shape = FabricUtils.toShape((int)value);
        shape = SwatchShapeIndex.transform((Transform)Transform.ReflectX, (int)shape, (int)1);
        return FabricUtils.toCell((int)shape, (int)fabric);
    }
}

