/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.simsilica.sim.GameSystem;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTiming {
    static Logger log = LoggerFactory.getLogger(SystemTiming.class);
    private final Map<GameSystem, TimingInfo> timingIndex = new LinkedHashMap<GameSystem, TimingInfo>();
    private long frameStart;
    private long frameEnd;
    private long timingCheckThresholdNanos = 100000000L;

    public void setTimingCheckThreshold(long checkMs) {
        this.timingCheckThresholdNanos = checkMs * 1000000L;
    }

    public long getTimingCheckThreshold() {
        return this.timingCheckThresholdNanos / 1000000L;
    }

    public void startFrame() {
        this.frameStart = System.nanoTime();
    }

    public void endFrame() {
        this.frameEnd = System.nanoTime();
        this.checkTiming(this.frameStart, this.frameEnd);
    }

    protected void checkTiming(long start, long end) {
        long delta = end - start;
        if (delta > this.timingCheckThresholdNanos) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<GameSystem, TimingInfo> e : this.timingIndex.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(e.getValue() + " : " + e.getKey());
            }
            log.warn(String.format("Update loop exceeds %d ms, at: %.03f ms  System info: %s", this.getTimingCheckThreshold(), (double)delta / 1000000.0, sb));
        }
    }

    public TimingInfo trackUpdate(GameSystem sys) {
        return this.getTiming(sys, true).open();
    }

    public Map<GameSystem, TimingInfo> getAllTimingInfo() {
        return this.timingIndex;
    }

    protected TimingInfo getTiming(GameSystem sys, boolean create) {
        TimingInfo result = this.timingIndex.get(sys);
        if (result == null && create) {
            result = new TimingInfo(sys);
            this.timingIndex.put(sys, result);
        }
        return result;
    }

    public static class TimingInfo
    implements AutoCloseable {
        private final GameSystem sys;
        private long start;
        private long stop;

        public TimingInfo(GameSystem sys) {
            this.sys = sys;
        }

        protected TimingInfo open() {
            this.start = System.nanoTime();
            return this;
        }

        @Override
        public void close() {
            this.stop = System.nanoTime();
        }

        public long getDurationNanos() {
            return this.stop - this.start;
        }

        public double getDurationMillis() {
            return (double)this.getDurationNanos() / 1000000.0;
        }

        public String toString() {
            return String.format("%.03f ms", this.getDurationMillis());
        }
    }
}

