/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.theora;

import de.jarnbjo.theora.Constants;
import de.jarnbjo.theora.PbInstance;
import java.util.Arrays;

public class PostProcess {
    private static final int[] sharpenModifier = new int[]{-12, -11, -10, -10, -9, -9, -9, -9, -6, -6, -6, -6, -6, -6, -6, -6, -4, -4, -4, -4, -4, -4, -4, -4, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] dcQuantScaleV1 = new int[]{22, 20, 19, 18, 17, 17, 16, 16, 15, 15, 14, 14, 13, 13, 12, 12, 11, 11, 10, 10, 9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1};
    private static int deringModifierV1;

    static void postProcess(PbInstance pbi) {
        switch (pbi.postProcessingLevel) {
            case 8: {
                PostProcess.deblockFrame(pbi, pbi.lastFrameRecon, pbi.postProcessBuffer);
                break;
            }
            case 6: {
                PostProcess.deblockFrame(pbi, pbi.lastFrameRecon, pbi.postProcessBuffer);
                PostProcess.updateUmvBorder(pbi, pbi.postProcessBuffer);
                PostProcess.deringFrame(pbi, pbi.postProcessBuffer, pbi.postProcessBuffer);
                break;
            }
            case 5: {
                PostProcess.deblockFrame(pbi, pbi.lastFrameRecon, pbi.postProcessBuffer);
                PostProcess.updateUmvBorder(pbi, pbi.postProcessBuffer);
                PostProcess.deringFrame(pbi, pbi.postProcessBuffer, pbi.postProcessBuffer);
                break;
            }
            case 4: {
                PostProcess.deblockFrame(pbi, pbi.lastFrameRecon, pbi.postProcessBuffer);
                break;
            }
            case 1: {
                PostProcess.updateFragQIndex(pbi);
                break;
            }
            case 0: {
                break;
            }
            default: {
                PostProcess.deblockFrame(pbi, pbi.lastFrameRecon, pbi.postProcessBuffer);
                PostProcess.updateUmvBorder(pbi, pbi.postProcessBuffer);
                PostProcess.deringFrame(pbi, pbi.postProcessBuffer, pbi.postProcessBuffer);
            }
        }
    }

    static void deblockFrame(PbInstance pbi, byte[] sourceBuffer, byte[] destinationBuffer) {
        Arrays.fill(pbi.fragmentVariances, 0);
        PostProcess.updateFragQIndex(pbi);
        PostProcess.setupLoopFilter(pbi);
    }

    static void deringBlockStrong(byte[] srcPtr, int srcOffset, byte[] dstPtr, int dstOffset, int pitch, int fragQIndex, int[] quantScale) {
        int tmpMod;
        int j;
        int k;
        short[] udMod = new short[72];
        short[] lrMod = new short[72];
        int qValue = quantScale[fragQIndex];
        byte[] curRow = srcPtr;
        byte[] dstRow = dstPtr;
        int lastRowOffset = srcOffset - pitch;
        int nextRowOffset = srcOffset + pitch;
        int rowOffset = 0;
        int round = 64;
        int sharpen = sharpenModifier[fragQIndex];
        int high = 3 * qValue;
        if (high > 32) {
            high = 32;
        }
        int low = 0;
        int src = srcOffset - pitch;
        for (k = 0; k < 9; ++k) {
            j = 0;
            while (j < 8) {
                tmpMod = srcPtr[src + j + pitch] - srcPtr[src + j];
                if (tmpMod > 0) {
                    tmpMod = -tmpMod;
                }
                if ((tmpMod += 32 + qValue) < -64) {
                    tmpMod = sharpen;
                } else if (tmpMod < low) {
                    tmpMod = low;
                } else if (tmpMod > high) {
                    tmpMod = high;
                }
                udMod[k * 8 + j] = (short)tmpMod;
                ++k;
            }
            src += pitch;
        }
        src = srcOffset - 1;
        for (k = 0; k < 9; ++k) {
            j = 0;
            while (j < 8) {
                tmpMod = srcPtr[src + j + 1] - srcPtr[src + j];
                if (tmpMod > 0) {
                    tmpMod = -tmpMod;
                }
                if ((tmpMod += 32 + qValue) < -64) {
                    tmpMod = sharpen;
                }
                if (tmpMod < 0) {
                    tmpMod = low;
                }
                if (tmpMod > high) {
                    tmpMod = high;
                }
                lrMod[k * 9 + j] = (short)tmpMod;
                ++k;
            }
            src += pitch;
        }
        for (k = 0; k < 8; ++k) {
            for (int l = 0; l < 8; ++l) {
                int atot = 128;
                int b = round;
                byte p = srcPtr[srcOffset + rowOffset + 1 + 1];
                byte pl = srcPtr[srcOffset + rowOffset + 1];
                short al = lrMod[k * 9 + l];
                atot -= al;
                b += al * pl;
                byte pu = srcPtr[lastRowOffset + rowOffset + 1];
                short au = udMod[k * 8 + l];
                atot -= au;
                b += au * pu;
                byte pd = srcPtr[nextRowOffset + rowOffset + l];
                short ad = udMod[(k + 1) * 8 + l];
                atot -= ad;
                b += ad * pd;
                byte pr = srcPtr[srcOffset + rowOffset + l + 2];
                short ar = lrMod[k * 9 + l + 1];
                int newVal = (atot -= ar) * p + (b += ar * pr) >> 7;
                dstPtr[dstOffset + rowOffset + l] = PostProcess.clamp255(newVal);
            }
            rowOffset += pitch;
        }
    }

    static void deringBlockWeak(byte[] srcPtr, int srcOffset, byte[] dstPtr, int dstOffset, int pitch, int fragQIndex, int[] quantScale) {
        PostProcess.deringBlockStrong(srcPtr, srcOffset, dstPtr, dstOffset, pitch, fragQIndex, quantScale);
    }

    static void deringFrame(PbInstance pbi, byte[] src, byte[] dst) {
        int variance;
        int quality;
        int col;
        int row;
        int thresh1 = 384;
        int thresh2 = 4 * thresh1;
        int thresh3 = 5 * thresh2 / 4;
        int thresh4 = 5 * thresh2 / 2;
        int[] quantScale = dcQuantScaleV1;
        int blocksAcross = pbi.hFragments;
        int blocksDown = pbi.hFragments;
        int srcOffset = pbi.reconYDataOffset;
        int dstOffset = pbi.reconYDataOffset;
        int lineLength = pbi.yStride;
        int block = 0;
        for (row = 0; row < blocksDown; ++row) {
            for (col = 0; col < blocksAcross; ++col) {
                quality = pbi.fragQIndex[block];
                variance = pbi.fragmentVariances[block];
                if (pbi.postProcessingLevel > 5 && variance > thresh3) {
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                    if (col > 0 && pbi.fragmentVariances[block - 1] > thresh4 || col + 1 < blocksAcross && pbi.fragmentVariances[block + 1] > thresh4 || row + 1 < blocksDown && pbi.fragmentVariances[block + blocksAcross] > thresh4 || row > 0 && pbi.fragmentVariances[block - blocksAcross] > thresh4) {
                        PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                        PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                    }
                } else if (variance > thresh2) {
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else if (variance > thresh1) {
                    PostProcess.deringBlockWeak(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else {
                    PostProcess.copyBlock(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength);
                }
                ++block;
            }
            srcOffset += 8 * lineLength;
            dstOffset += 8 * lineLength;
        }
        blocksAcross /= 2;
        blocksDown /= 2;
        lineLength /= 2;
        srcOffset = pbi.reconUDataOffset;
        dstOffset = pbi.reconUDataOffset;
        for (row = 0; row < blocksDown; ++row) {
            for (col = 0; col < blocksAcross; ++col) {
                quality = pbi.fragQIndex[block];
                variance = pbi.fragmentVariances[block];
                if (pbi.postProcessingLevel > 5 && variance > thresh4) {
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else if (variance > thresh2) {
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else if (variance > thresh1) {
                    PostProcess.deringBlockWeak(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else {
                    PostProcess.copyBlock(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength);
                }
                ++block;
            }
            srcOffset += 8 * lineLength;
            dstOffset += 8 * lineLength;
        }
        srcOffset = pbi.reconVDataOffset;
        dstOffset = pbi.reconVDataOffset;
        for (row = 0; row < blocksDown; ++row) {
            for (col = 0; col < blocksAcross; ++col) {
                quality = pbi.fragQIndex[block];
                variance = pbi.fragmentVariances[block];
                if (pbi.postProcessingLevel > 5 && variance > thresh4) {
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else if (variance > thresh2) {
                    PostProcess.deringBlockStrong(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else if (variance > thresh1) {
                    PostProcess.deringBlockWeak(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength, quality, quantScale);
                } else {
                    PostProcess.copyBlock(src, srcOffset + 8 * col, dst, dstOffset + 8 * col, lineLength);
                }
                ++block;
            }
            srcOffset += 8 * lineLength;
            dstOffset += 8 * lineLength;
        }
    }

    static void updateFragQIndex(PbInstance pbi) {
        int thisFrameQIndex = pbi.frameQIndex;
        for (int i = 0; i < pbi.unitFragments; ++i) {
            if (pbi.displayFragments[i] == 0) continue;
            pbi.fragQIndex[i] = thisFrameQIndex;
        }
    }

    static byte clamp255(int x) {
        if (x < 0) {
            return 0;
        }
        if (x > 255) {
            return -1;
        }
        return (byte)x;
    }

    static void copyBlock(byte[] src, int srcOff, byte[] dest, int destOff, int stride) {
        for (int j = 0; j < 8; ++j) {
            dest[destOff] = src[srcOff];
            dest[destOff + 1] = src[srcOff + 1];
            srcOff += stride;
            destOff += stride;
        }
    }

    static void updateUmvBorder(PbInstance pbi, byte[] destReconPtr) {
        int planeFragOffset = 0;
        PostProcess.updateUmvVBorders(pbi, destReconPtr, planeFragOffset);
        PostProcess.updateUmvHBorders(pbi, destReconPtr, planeFragOffset);
        planeFragOffset = pbi.yPlaneFragments;
        PostProcess.updateUmvVBorders(pbi, destReconPtr, planeFragOffset);
        PostProcess.updateUmvHBorders(pbi, destReconPtr, planeFragOffset);
        planeFragOffset = pbi.yPlaneFragments + pbi.uvPlaneFragments;
        PostProcess.updateUmvVBorders(pbi, destReconPtr, planeFragOffset);
        PostProcess.updateUmvHBorders(pbi, destReconPtr, planeFragOffset);
    }

    static void updateUmvHBorders(PbInstance pbi, byte[] destReconPtr, int planeFragOffset) {
        int lineFragments;
        int planeFragments;
        int planeBorderWidth;
        int planeStride;
        int blockVStep;
        if (planeFragOffset == 0) {
            blockVStep = pbi.yStride * 7;
            planeStride = pbi.yStride;
            planeBorderWidth = 16;
            planeFragments = pbi.yPlaneFragments;
            lineFragments = pbi.hFragments;
        } else {
            blockVStep = pbi.uvStride * 7;
            planeStride = pbi.uvStride;
            planeBorderWidth = 8;
            planeFragments = pbi.uvPlaneFragments;
            lineFragments = pbi.hFragments / 2;
        }
        int pixelIndex = pbi.reconPixelIndexTable[planeFragOffset];
        int sOff1 = pixelIndex - planeBorderWidth;
        int dOff1 = sOff1 - planeBorderWidth * planeStride;
        pixelIndex = pbi.reconPixelIndexTable[planeFragOffset + planeFragments - lineFragments] + blockVStep;
        int sOff2 = pixelIndex - planeBorderWidth;
        int dOff2 = sOff2 + planeStride;
        for (int i = 0; i < planeBorderWidth; ++i) {
            System.arraycopy(destReconPtr, sOff1, destReconPtr, dOff1, planeStride);
            System.arraycopy(destReconPtr, sOff2, destReconPtr, dOff2, planeStride);
            dOff1 += planeStride;
            dOff2 += planeStride;
        }
    }

    static void updateUmvVBorders(PbInstance pbi, byte[] destReconPtr, int planeFragOffset) {
        int pixelIndex;
        int planeHeight;
        int lineFragments;
        int planeBorderWidth;
        int planeStride;
        if (planeFragOffset == 0) {
            planeStride = pbi.yStride;
            planeBorderWidth = 16;
            lineFragments = pbi.hFragments;
            planeHeight = pbi.info.getHeight();
        } else {
            planeStride = pbi.uvStride;
            planeBorderWidth = 8;
            lineFragments = pbi.hFragments / 2;
            planeHeight = pbi.info.getHeight() / 2;
        }
        int sOff1 = pixelIndex = pbi.reconPixelIndexTable[planeFragOffset];
        int dOff1 = pixelIndex - planeBorderWidth;
        int sOff2 = pixelIndex = pbi.reconPixelIndexTable[planeFragOffset + lineFragments - 1] + 8 - 1;
        int dOff2 = pixelIndex + 1;
        for (int i = 0; i < planeHeight; ++i) {
            System.arraycopy(destReconPtr, sOff1, destReconPtr, dOff1, planeBorderWidth);
            System.arraycopy(destReconPtr, sOff2, destReconPtr, dOff2, planeBorderWidth);
            sOff1 += planeStride;
            sOff2 += planeStride;
            dOff1 += planeStride;
            dOff2 += planeStride;
        }
    }

    static void setupLoopFilter(PbInstance pbi) {
        int fLimit = Constants.loopFilterLimitValuesV2[pbi.frameQIndex];
        pbi.setupBoundingValueArrayGeneric(fLimit);
    }
}

