/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class DebugUtils {
    private static String nanoFormat = "#,### nanos";
    private static String msFormat = "#,###.## ms";
    private static ThreadLocal<NumberFormat> nano = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat(nanoFormat);
        }
    };
    private static ThreadLocal<NumberFormat> ms = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            return new DecimalFormat(msFormat);
        }
    };

    public static String nanoString(long nanos) {
        return nano.get().format(nanos);
    }

    public static String msString(long nanos) {
        return ms.get().format((double)nanos / 1000000.0);
    }

    public static String timeString(long nanos) {
        return DebugUtils.nanoString(nanos) + " (" + DebugUtils.msString(nanos) + ")";
    }

    public static void main(String ... args) {
        long time = System.nanoTime();
        System.out.println("Nano test:" + DebugUtils.nanoString(time));
        System.out.println("MS test:" + DebugUtils.msString(time));
        System.out.println("Time test:" + DebugUtils.timeString(time));
    }
}

