/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Statistics {
    private static final ConcurrentHashMap<String, Counter> counters = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Tracker> trackers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Sequence> sequences = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Counter getCounter(String name, boolean create) {
        Counter result = counters.get(name);
        if (result == null && create) {
            ConcurrentHashMap<String, Counter> concurrentHashMap = counters;
            synchronized (concurrentHashMap) {
                result = counters.get(name);
                if (result == null) {
                    result = new Counter(name);
                    counters.put(name, result);
                }
            }
        }
        return result;
    }

    public static long getCounterValue(String name) {
        Counter result = counters.get(name);
        return result == null ? -1L : result.get();
    }

    public static Set<String> counterNames() {
        return Collections.unmodifiableSet(counters.keySet());
    }

    public static Tracker getTracker(String name, boolean create) {
        return Statistics.getTracker(name, 0, create);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracker getTracker(String name, int windowSize, boolean create) {
        Tracker result = trackers.get(name);
        if (result == null && create) {
            ConcurrentHashMap<String, Tracker> concurrentHashMap = trackers;
            synchronized (concurrentHashMap) {
                result = trackers.get(name);
                if (result == null) {
                    result = new Tracker(name, windowSize);
                    trackers.put(name, result);
                }
            }
        }
        return result;
    }

    public static long getTrackerValue(String name) {
        Tracker result = trackers.get(name);
        return result == null ? -1L : result.get();
    }

    public static Set<String> trackerNames() {
        return Collections.unmodifiableSet(trackers.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence getSequence(String name, boolean create) {
        Sequence result = sequences.get(name);
        if (result == null && create) {
            ConcurrentHashMap<String, Sequence> concurrentHashMap = sequences;
            synchronized (concurrentHashMap) {
                result = sequences.get(name);
                if (result == null) {
                    result = new Sequence(name);
                    sequences.put(name, result);
                }
            }
        }
        return result;
    }

    public static Set<String> sequenceNames() {
        return Collections.unmodifiableSet(sequences.keySet());
    }

    public static class Sequence {
        private final String name;
        private final ConcurrentLinkedQueue<Long> values = new ConcurrentLinkedQueue();
        private final int maxSize = 1000;

        public Sequence(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEmpty() {
            return this.values.isEmpty();
        }

        public void add(Long value) {
            this.values.add(value);
            while (this.values.size() > 1000) {
                this.values.poll();
            }
        }

        public Long poll() {
            return this.values.poll();
        }

        public String toString() {
            return "Sequence[" + this.getName() + " size=" + this.values.size() + "]";
        }
    }

    public static class Tracker
    extends AbstractValue<Long> {
        private long value;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private long size;
        private final long windowSize;

        public Tracker(String name, long windowSize) {
            super(name);
            this.windowSize = windowSize;
        }

        public long get() {
            this.lock.readLock().lock();
            try {
                long l = this.value;
                return l;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long update(long newValue) {
            this.lock.writeLock().lock();
            try {
                long count = Math.min(this.size, this.windowSize);
                ++this.size;
                long l = this.value = (this.value * count + newValue) / (count + 1L);
                return l;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public String toString() {
            return "Tracker[" + this.getName() + "=" + this.get() + "]";
        }
    }

    public static class Counter
    extends AbstractValue<Long> {
        private final AtomicLong counter = new AtomicLong();

        public Counter(String name) {
            super(name);
        }

        public long get() {
            return this.counter.get();
        }

        public long increment() {
            this.incrementVersion();
            return this.counter.incrementAndGet();
        }

        public long decrement() {
            this.incrementVersion();
            return this.counter.decrementAndGet();
        }

        public long add(long value) {
            this.incrementVersion();
            return this.counter.incrementAndGet();
        }

        public String toString() {
            return "Counter[" + this.getName() + "=" + this.counter.get() + "]";
        }
    }

    protected static abstract class AbstractValue<T> {
        private final String name;
        private final AtomicLong version;

        protected AbstractValue(String name) {
            this.name = name;
            this.version = new AtomicLong();
        }

        public String getName() {
            return this.name;
        }

        protected void incrementVersion() {
            this.version.incrementAndGet();
        }
    }
}

