/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.CharacterRig;
import com.simsilica.crig.RigShape;
import com.simsilica.crig.sim.AnimPump;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.phys.KinematicInfo;
import com.simsilica.mblock.phys.MBlockContact;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mblock.phys.Part;
import com.simsilica.mphys.AbstractBody;
import com.simsilica.mphys.AbstractControlDriver;
import com.simsilica.mphys.Contact;
import com.simsilica.mphys.Frustum;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.QueryVolume;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mworld.World;
import com.simsilica.mworld.WorldView;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mythruna.GameConstants;
import mythruna.es.MovementInput;
import mythruna.sim.Activity;
import mythruna.sim.BodyAttachment;
import mythruna.sim.CharacterDriver;
import mythruna.sim.SwingDownActivity;
import mythruna.sim.SwingLeftActivity;
import mythruna.sim.ai.PerceptionSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerDriver
extends AbstractControlDriver<EntityId, MBlockShape>
implements CharacterDriver {
    static Logger log = LoggerFactory.getLogger(PlayerDriver.class);
    private static final int phase = 2;
    private EntityData ed;
    private EntityId player;
    private Map<String, BodyAttachment> attachments = new HashMap<String, BodyAttachment>();
    private long frame = 0L;
    private Vec3d vTemp = new Vec3d();
    private double walkSpeed = 3.5;
    private double runSpeed = 3.25;
    private double groundImpulse = 200.0;
    private Vec3d desiredFlatVelocity = new Vec3d();
    private Vec3d desiredNaturalVelocity = new Vec3d();
    private Vec3d flatForward = new Vec3d();
    private Vec3d naturalForward = new Vec3d();
    private Vec3d sideways = new Vec3d();
    private Quatd facing = new Quatd();
    private Quatd flatFacing = new Quatd();
    private Vec3d flatDir = new Vec3d();
    private boolean jump;
    private boolean running;
    private Vec3d walkVelocity = new Vec3d();
    private double averageWalkSpeed = 0.0;
    private double upThreshold = 0.7;
    private double verticalThreshold = 0.42;
    private double jumpForce = 9.0;
    private boolean shortJumps = true;
    private boolean autoBounce = true;
    private int groundContactCount = 0;
    private Vec3d groundVelocity = new Vec3d();
    private EntityId groundEntity;
    private boolean standing = false;
    private boolean canJump = false;
    private boolean isJumping = false;
    private boolean autoclimbEnabled = true;
    private double climbForce;
    private double highestSideContact;
    private boolean autoclimb;
    private boolean isClimbing;
    private Vec3d force;
    private double[] angles;
    private boolean noGravity;
    private boolean enabled;
    private RigShape rigShape;
    private AnimPump animPump;
    private boolean drag1;
    private AttachmentPoint dragAttachmentPoint;
    private Vec3d dragOffset;
    private Quatd dragOrientation;
    private double xDrag;
    private double yDrag;
    private boolean drag1Blocked;
    private Vec3d blockNormal;
    private Map<String, MBlockContact> newContacts;
    private Map<String, MBlockContact> oldContacts;
    private WorldView worldView;
    private boolean wet;
    private Activity currentActivity;
    private BodyAttachment rightHand;
    private Frustum sightVolume;
    private PerceptionSet sightPerception;
    private Map<String, Activity> activities;
    private long nextSpawnUpdateTime;
    private long updateInterval;

    public PlayerDriver(World world, EntityData ed, EntityId player, MPhysSystem<MBlockShape> physics) {
        this.climbForce = 4.0 + -GameConstants.DEFAULT_GRAVITY.y;
        this.highestSideContact = 0.0;
        this.autoclimb = false;
        this.isClimbing = false;
        this.force = new Vec3d();
        this.angles = new double[3];
        this.noGravity = false;
        this.enabled = true;
        this.drag1 = false;
        this.dragOffset = new Vec3d(0.0, 0.0, 1.0);
        this.dragOrientation = new Quatd();
        this.xDrag = 0.0;
        this.yDrag = 0.0;
        this.drag1Blocked = false;
        this.blockNormal = new Vec3d();
        this.newContacts = new HashMap<String, MBlockContact>();
        this.oldContacts = new HashMap<String, MBlockContact>();
        this.activities = new HashMap<String, Activity>();
        this.nextSpawnUpdateTime = 0L;
        this.updateInterval = 5000000000L;
        this.ed = ed;
        this.player = player;
        this.worldView = new WorldView(world);
        double rads = Math.toRadians(70.0);
        this.sightVolume = new Frustum(32.0, rads * 1.778, rads);
        this.sightPerception = new PerceptionSet((QueryVolume)this.sightVolume, (PhysicsSpace<EntityId, MBlockShape>)physics.getPhysicsSpace());
        this.sightPerception.setSkip(player);
    }

    public Frustum getSightVolume() {
        return this.sightVolume;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void startActivity(String name) {
        log.info(this.frame + " startActivity(" + name + ")");
        Activity activity = this.activities.get(name);
        if (activity == null) {
            log.warn("No activity for:" + name);
            return;
        }
        if (this.currentActivity != null) {
            this.currentActivity.reset();
        }
        this.currentActivity = activity;
    }

    public void endActivity(String name) {
        log.info(this.frame + " endActivity(" + name + ")");
        if (this.currentActivity != null) {
            this.currentActivity.reset();
            this.currentActivity = null;
        }
        if (this.rightHand != null && this.rightHand.getPart().getKinematicInfo() != null) {
            this.rightHand.getPart().getKinematicInfo().setScale(0.0);
        }
    }

    public void initialize(RigidBody<EntityId, MBlockShape> body) {
        super.initialize(body);
        log.info("initialize(" + body + ")");
        log.info("AttachmentSystem initialize(" + body.id + ")");
        if (this.noGravity) {
            body.setLinearAcceleration(new Vec3d(0.0, 0.0, 0.0));
        }
        body.setLinearDamping(0.2);
        if (body.shape instanceof RigShape) {
            this.rigShape = (RigShape)body.shape;
            this.animPump = new AnimPump((CharacterRig)this.rigShape, null);
            this.animPump.setCurrentAction("Idle", 1.0);
            this.rigShape.update();
            log.info("rig shape:" + this.rigShape);
            this.activities.put("Swing Left", new SwingLeftActivity(this.rigShape, this.animPump));
            this.activities.put("Swing Down", new SwingDownActivity(this.rigShape, this.animPump));
        }
    }

    public void applyMovementInput(MovementInput input) {
        double flatRads;
        if (log.isTraceEnabled()) {
            log.trace("applyInput(" + input + ")");
        }
        this.jump = input.isJumping();
        this.drag1 = input.isDrag1();
        if (!this.drag1) {
            this.facing.set(input.getFacing());
            this.dragAttachmentPoint = null;
            this.drag1Blocked = false;
        } else {
            if (this.dragAttachmentPoint == null) {
                this.dragAttachmentPoint = this.rigShape.getAttachmentPoint("hand.right");
                log.info("Found attachment point:" + this.dragAttachmentPoint);
            }
            this.getBody().orientation.inverse().mult(input.getFacing(), this.dragOrientation);
            this.dragOffset.set(0.0, 0.0, 1.0);
            this.dragOrientation.mult(this.dragOffset, this.dragOffset);
            if (Double.isNaN(this.dragOffset.x)) {
                log.info("NaN drag offset, facing:" + input.getFacing());
                this.dragOffset.set(0.0, 0.0, 1.0);
            }
            Vec3d xz = new Vec3d(this.dragOffset.x, 0.0, this.dragOffset.z);
            double length = xz.length();
            xz.multLocal(1.0 / length);
            double xAngle = Math.atan2(xz.x, xz.z);
            double yAngle = Math.atan2(this.dragOffset.y, length);
            double minAngle = -1.5707963267948966;
            double maxAngle = 1.5707963267948966;
            if (xAngle < minAngle) {
                xAngle = minAngle;
            } else if (xAngle > maxAngle) {
                xAngle = maxAngle;
            }
            double xNewDrag = (xAngle - minAngle) / (maxAngle - minAngle);
            minAngle = -0.47123889803846897;
            maxAngle = 0.47123889803846897;
            if (yAngle < minAngle) {
                yAngle = minAngle;
            } else if (yAngle > maxAngle) {
                yAngle = maxAngle;
            }
            double yNewDrag = (yAngle - minAngle) / (maxAngle - minAngle);
            boolean haltDrag = this.drag1Blocked;
            Vec3d dragDir = new Vec3d(xNewDrag - this.xDrag, yNewDrag - this.yDrag, 0.0);
            dragDir.normalizeLocal();
            if (haltDrag) {
                Vec3d localNormal = this.getBody().orientation.inverse().mult(this.blockNormal);
                double dot = localNormal.dot(dragDir);
                log.info("*** dot:" + dot);
                if (dot > 0.0) {
                    haltDrag = false;
                }
            }
            if (!haltDrag) {
                this.xDrag = xNewDrag;
                this.yDrag = yNewDrag;
                log.info("xDrag:" + this.xDrag + "   yDrag:" + this.yDrag);
            }
        }
        Vec3d move = input.getMove();
        double up = move.y;
        this.running = false;
        this.flatForward.set(0.0, 0.0, move.z);
        this.naturalForward.set(0.0, 0.0, move.z);
        if (Math.abs(move.z) > 0.001) {
            this.facing.mult(this.flatForward, this.flatForward);
            this.flatForward.y = 0.0;
            this.flatForward.normalizeLocal().multLocal(Math.abs(move.z));
            this.facing.mult(this.naturalForward, this.naturalForward);
            if (Math.abs(move.z) > 1.0) {
                this.running = true;
            }
        }
        this.sideways.set(move.x, 0.0, 0.0);
        if (Math.abs(move.x) > 0.001) {
            this.facing.mult(this.sideways, this.sideways);
            this.sideways.y = 0.0;
            this.sideways.normalizeLocal().multLocal(Math.abs(move.x));
            if (Math.abs(move.x) > 1.0) {
                this.running = true;
            }
        }
        if (this.running) {
            this.flatForward.multLocal(this.runSpeed);
            this.naturalForward.multLocal(this.runSpeed);
            this.sideways.multLocal(this.runSpeed);
            up *= this.runSpeed;
        } else {
            this.flatForward.multLocal(this.walkSpeed);
            this.naturalForward.multLocal(this.walkSpeed);
            this.sideways.multLocal(this.walkSpeed);
            up *= this.walkSpeed;
        }
        this.desiredFlatVelocity.set(this.flatForward).addLocal(this.sideways);
        this.desiredFlatVelocity.y += up;
        this.desiredNaturalVelocity.set(this.naturalForward).addLocal(this.sideways);
        Vec3d dir = this.facing.mult(Vec3d.UNIT_Z);
        if ((this.flatForward.lengthSq() > 0.0 || this.sideways.lengthSq() > 0.0) && !this.drag1) {
            Vec3d flatMove = this.flatForward.add(this.sideways).normalizeLocal();
            if (this.flatForward.dot(dir) < 0.0) {
                flatMove = flatMove.mult(-1.0);
            }
            dir = flatMove;
        }
        if (Double.isNaN(flatRads = Math.atan2(dir.x, dir.z)) || Double.isInfinite(flatRads)) {
            flatRads = 0.0;
        }
        this.flatFacing.fromAngles(0.0, flatRads, 0.0);
        this.flatDir = this.flatFacing.mult(Vec3d.UNIT_Z, this.flatDir);
    }

    @Override
    public void updateAttachment(String attachmentName, BodyAttachment attachment) {
        log.info(this.player + " -> updateAttachment(" + attachmentName + ", " + attachment + ")");
        this.attachments.put(attachmentName, attachment);
        if ("hand.right".equals(attachmentName)) {
            this.rightHand = attachment;
        }
    }

    private String contactToId(MBlockContact contact) {
        StringBuilder sb = new StringBuilder();
        if (contact.body1 != null) {
            sb.append(String.valueOf(contact.body1.id));
        }
        sb.append(":");
        if (contact.part1 != null) {
            sb.append(contact.part1.getName());
        } else {
            sb.append(contact.type1);
        }
        sb.append("->");
        if (contact.body2 != null) {
            sb.append(String.valueOf(contact.body2.id));
        }
        sb.append(":");
        if (contact.part2 != null) {
            sb.append(contact.part2.getName());
        } else {
            sb.append(contact.type2);
        }
        return sb.toString();
    }

    protected String toString(int typeIndex) {
        BlockType type = BlockTypeIndex.get((int)typeIndex);
        String name = type == null ? "null" : String.valueOf(type.getName());
        return name + "(" + typeIndex + ")";
    }

    protected void handleSwingContact(RigidBody<EntityId, MBlockShape> thisBody, Part part1, int type1, RigidBody<EntityId, MBlockShape> otherBody, Part part2, int type2, MBlockContact<EntityId> contact) {
        if (this.rightHand == null) {
            return;
        }
        if (part1 == null) {
            return;
        }
        KinematicInfo k1 = part1.getKinematicInfo();
        if (k1 == null) {
            return;
        }
        k1.setScale(0.0);
        if (this.currentActivity == null) {
            return;
        }
        if (!Objects.equals(this.rightHand.getAttachment(), k1.getId())) {
            log.info("Ignoring. Right hand attachment:" + this.rightHand.getAttachment() + "  kinematic attachment:" + k1.getId());
            return;
        }
        Vec3d kVelocity = k1.getPointVelocity(thisBody, contact.contactPoint);
        this.currentActivity.newContact(contact, type1, type2, kVelocity);
    }

    public void newContact(Contact<EntityId, MBlockShape> contact) {
        MBlockContact mContact = (MBlockContact)contact;
        RigidBody body = this.getBody();
        RigidBody thisBody = null;
        RigidBody otherBody = null;
        Part part1 = null;
        Part part2 = null;
        int type1 = -1;
        int type2 = -1;
        if (contact.body1 == body) {
            thisBody = body;
            if (otherBody instanceof RigidBody) {
                otherBody = (RigidBody)contact.body2;
            }
            type1 = mContact.type1;
            type2 = mContact.type2;
            part1 = mContact.part1;
            part2 = mContact.part2;
        } else if (contact.body2 == body) {
            thisBody = body;
            otherBody = contact.body1;
            type1 = mContact.type2;
            type2 = mContact.type1;
            part1 = mContact.part2;
            part2 = mContact.part1;
        } else {
            log.error("Body:" + body.id + " received newContact() for some other body:" + contact);
            return;
        }
        this.handleSwingContact((RigidBody<EntityId, MBlockShape>)thisBody, part1, type1, (RigidBody<EntityId, MBlockShape>)otherBody, part2, type2, (MBlockContact<EntityId>)mContact);
        double upness = Vec3d.UNIT_Y.dot(contact.contactNormal);
        if (upness < this.upThreshold) {
            contact.friction = 0.0;
            double dot = this.desiredFlatVelocity.dot(contact.contactNormal);
            if (dot < 0.0) {
                double yRelative = contact.contactPoint.y - thisBody.position.y;
                this.highestSideContact = Math.max(yRelative, this.highestSideContact);
                this.autoclimb = this.autoclimbEnabled;
            }
            return;
        }
        if (upness > this.verticalThreshold) {
            this.canJump = true;
            this.standing = true;
        } else {
            this.canJump = this.autoclimbEnabled;
        }
        if (otherBody instanceof RigidBody) {
            this.groundVelocity.addLocal(otherBody.getLinearVelocity());
            ++this.groundContactCount;
            this.groundEntity = (EntityId)otherBody.id;
        }
    }

    protected void calculateCollisionData() {
        if (this.groundContactCount > 0) {
            this.groundVelocity.multLocal(1.0 / (double)this.groundContactCount);
            if (log.isDebugEnabled()) {
                log.debug("walk: groundVelocity:" + this.groundVelocity);
            }
        }
    }

    protected void invalidateCollisionData() {
        this.groundEntity = null;
        this.groundContactCount = 0;
        this.groundVelocity.set(0.0, 0.0, 0.0);
        this.canJump = false;
        this.standing = false;
        this.highestSideContact = 0.0;
        this.autoclimb = false;
        this.isClimbing = false;
        for (Map.Entry<String, MBlockContact> e : this.newContacts.entrySet()) {
            if (!this.oldContacts.containsKey(e.getKey())) continue;
        }
        this.oldContacts.clear();
        this.oldContacts.putAll(this.newContacts);
        this.newContacts.clear();
        this.drag1Blocked = false;
    }

    protected void killVerticalRotation(RigidBody<EntityId, MBlockShape> body) {
        body.orientation.toAngles(this.angles);
        if (this.angles[0] != 0.0 || this.angles[2] != 0.0) {
            this.angles[0] = 0.0;
            this.angles[2] = 0.0;
            body.orientation.fromAngles(this.angles);
        }
        Vec3d rot = body.getRotationalVelocity();
        if (rot.x != 0.0 || rot.z != 0.0) {
            rot.x = 0.0;
            rot.z = 0.0;
            body.setRotationalVelocity(rot);
        }
        if (body.position.y < 0.0) {
            body.position.y = 700.0;
        }
    }

    protected boolean setWet(boolean wet, RigidBody<EntityId, MBlockShape> body) {
        if (this.wet == wet) {
            return false;
        }
        this.wet = wet;
        if (wet) {
            body.setLinearAcceleration(GameConstants.WATER_GRAVITY);
            if (body.getLinearVelocity().y < -5.0) {
                log.info("***** SPLASH *****");
            }
            return true;
        }
        body.setLinearAcceleration(GameConstants.DEFAULT_GRAVITY);
        return false;
    }

    public void update(long frameTime, double step) {
        ++this.frame;
        if (!this.enabled) {
            return;
        }
        RigidBody body = this.getBody();
        if (log.isTraceEnabled()) {
            log.trace("update(" + step + ")  temperature:" + body.getTemperature());
        }
        this.calculateCollisionData();
        this.killVerticalRotation((RigidBody<EntityId, MBlockShape>)body);
        this.sightVolume.set(body.position.add(0.0, 0.8, 0.0), this.facing);
        this.sightPerception.update(step);
        int fluid = this.worldView.getFluid(body.position.add(0.0, 1.2, 0.0));
        int fluidType = FluidUtils.getType((int)fluid);
        boolean splash = false;
        if (fluidType != 0) {
            int fluidLevel = FluidUtils.getLevel((int)fluid);
            splash = this.setWet(true, (RigidBody<EntityId, MBlockShape>)body);
        } else {
            splash = this.setWet(false, (RigidBody<EntityId, MBlockShape>)body);
        }
        body.orientation.set(this.flatFacing);
        Vec3d velocity = body.getLinearVelocity();
        double verticalVelocity = velocity.y - this.groundVelocity.y;
        if (this.wet) {
            double up = this.desiredNaturalVelocity.y;
            if (this.standing && up < 0.0) {
                up = 0.0;
            }
            if (this.desiredFlatVelocity.y > 0.0) {
                up = Math.max(this.desiredFlatVelocity.y, up);
            }
            if (this.jump) {
                up = this.running ? Math.max(up, this.runSpeed) : Math.max(up, this.walkSpeed);
            }
            if (this.standing) {
                if (up != 0.0 || this.desiredFlatVelocity.lengthSq() > 0.0) {
                    this.force.set(this.desiredFlatVelocity);
                    this.force.y = up;
                    this.force.subtractLocal(velocity);
                    this.force.addLocal(this.groundVelocity);
                    if (up == 0.0) {
                        this.force.y = 0.0;
                    }
                    this.force.multLocal(this.groundImpulse * 10.0);
                    body.addForce(this.force);
                }
            } else if (up != 0.0 || this.desiredNaturalVelocity.lengthSq() > 0.0) {
                this.force.set(this.desiredNaturalVelocity);
                this.force.y = up;
                this.force.subtractLocal(velocity);
                this.force.addLocal(this.groundVelocity);
                log.info("wet up:" + up + "  force:" + this.force + " velocity:" + velocity);
                if (up == 0.0) {
                    this.force.y = 0.0;
                }
                this.force.multLocal(this.groundImpulse * 10.0);
                body.addForce(this.force);
            }
        } else if (this.noGravity) {
            body.getLinearVelocity().set(0.0, 0.0, 0.0);
        } else {
            if (this.desiredFlatVelocity.lengthSq() > 0.0) {
                this.force.set(this.desiredFlatVelocity).subtractLocal(velocity);
                this.force.addLocal(this.groundVelocity);
                if (this.desiredFlatVelocity.y == 0.0) {
                    this.force.y = 0.0;
                }
                this.force.multLocal(this.groundImpulse * 10.0);
                if (!this.isJumping && this.autoclimb && this.highestSideContact <= 0.0) {
                    double mass = 1.0 / body.getInverseMass();
                    this.force.y += this.climbForce * mass;
                    this.isClimbing = true;
                }
                body.addForce(this.force);
            }
            if (this.jump) {
                if ((this.isClimbing || this.canJump) && !this.isJumping) {
                    if (log.isDebugEnabled()) {
                        log.debug("walk: -------------------JUMP!   velocity.y:" + velocity.y);
                    }
                    velocity.y = this.groundVelocity.y;
                    velocity.y += this.jumpForce;
                    this.isJumping = true;
                }
            } else {
                if (this.shortJumps && this.isJumping && verticalVelocity > 0.0) {
                    if (log.isDebugEnabled()) {
                        log.debug("walk: ---------------KILL JUMP!");
                    }
                    velocity.y = Math.min(velocity.y, this.groundVelocity.y + 2.0);
                }
                this.isJumping = false;
            }
            if (this.isJumping && log.isDebugEnabled()) {
                log.debug("walk:  y velocity:" + verticalVelocity);
            }
            if (this.autoBounce && this.isJumping && verticalVelocity <= 0.0) {
                this.isJumping = false;
                if (log.isDebugEnabled()) {
                    log.debug("walk: ---------------Jump done, faling.");
                }
            }
        }
        if (this.currentActivity != null) {
            this.currentActivity.update(frameTime, step, this.facing.mult(Vec3d.UNIT_Z));
            if (this.rightHand != null && this.rightHand.getPart() != null && this.rightHand.getPart().getKinematicInfo() != null) {
                this.rightHand.getPart().getKinematicInfo().setScale(this.currentActivity.getKinematicScale());
            }
        } else if (this.drag1) {
            this.animPump.setCurrentAction("Swing", 0.0);
            this.animPump.setTime(this.xDrag);
            this.rigShape.setMix("Swing", this.yDrag);
            this.rigShape.update();
        } else if (this.animPump != null && step > 0.0) {
            double effectiveSpeed;
            String action = "Idle";
            double animSpeed = 1.0;
            if (!this.standing && Math.abs(verticalVelocity) > 0.01) {
                effectiveSpeed = 0.0;
            } else {
                this.walkVelocity.set(velocity);
                this.walkVelocity.subtractLocal(this.groundVelocity);
                if (!this.wet) {
                    this.walkVelocity.y = 0.0;
                }
                effectiveSpeed = this.walkVelocity.length();
                if (this.walkVelocity.dot(this.flatDir) < 0.0) {
                    effectiveSpeed = -effectiveSpeed;
                }
            }
            this.averageWalkSpeed = effectiveSpeed != 0.0 && this.averageWalkSpeed == 0.0 ? effectiveSpeed : (this.averageWalkSpeed + effectiveSpeed) / 2.0;
            double moveThreshold = Math.abs(this.averageWalkSpeed);
            if (!(moveThreshold < 0.001)) {
                if (moveThreshold < 1.8) {
                    action = "Walk";
                    animSpeed = 9.0 * (this.averageWalkSpeed / 2.0);
                } else {
                    action = "Jog";
                    animSpeed = this.averageWalkSpeed;
                }
            }
            if (action != null) {
                this.animPump.setCurrentAction(action, animSpeed);
                this.animPump.update(step);
                this.rigShape.update();
            }
        }
        body.wakeUp(true);
        this.invalidateCollisionData();
        if (frameTime > this.nextSpawnUpdateTime) {
            this.nextSpawnUpdateTime = frameTime + this.updateInterval;
            Vec3d wPos = ((MBlockShape)body.shape).getWorldShapeOrigin((AbstractBody)body);
            this.ed.setComponent(this.player, (EntityComponent)new SpawnPosition(GameConstants.PHYSICS_GRID, wPos, body.orientation));
        }
    }
}

