/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.CompactArray;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import java.io.IOException;

public class CompactFloatArray
extends CompactArray<Float>
implements Savable {
    public CompactFloatArray() {
    }

    public CompactFloatArray(float[] dataArray, int[] index) {
        super(dataArray, index);
    }

    @Override
    protected final int getTupleSize() {
        return 1;
    }

    @Override
    protected final Class<Float> getElementClass() {
        return Float.class;
    }

    @Override
    public void write(JmeExporter ex) throws IOException {
        this.serialize();
        OutputCapsule out = ex.getCapsule(this);
        out.write(this.array, "array", (float[])null);
        out.write(this.index, "index", (int[])null);
    }

    @Override
    public void read(JmeImporter im) throws IOException {
        InputCapsule in = im.getCapsule(this);
        this.array = in.readFloatArray("array", null);
        this.index = in.readIntArray("index", null);
    }

    public void fill(int startIndex, float[] store) {
        for (int i = 0; i < store.length; ++i) {
            store[i] = ((Float)this.get(startIndex + i, null)).floatValue();
        }
    }

    @Override
    protected void serialize(int i, Float data) {
        this.array[i] = data.floatValue();
    }

    @Override
    protected Float deserialize(int i, Float store) {
        return Float.valueOf(this.array[i]);
    }
}

