/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.input.AWTInput;
import com.jme3.input.KeyInput;
import com.jme3.input.event.KeyInputEvent;
import com.jme3.system.AWTContext;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class AWTKeyInput
extends AWTInput
implements KeyInput,
KeyListener {
    private static final Map<Integer, Integer> KEY_CODE_TO_JME = new HashMap<Integer, Integer>();
    private final LinkedList<KeyInputEvent> keyInputEvents = new LinkedList();

    public AWTKeyInput(AWTContext context) {
        super(context);
    }

    @Override
    public void bind(Component component) {
        super.bind(component);
        component.addKeyListener(this);
    }

    @Override
    public void unbind() {
        if (this.component != null) {
            this.component.removeKeyListener(this);
        }
        super.unbind();
    }

    private void onKeyEvent(KeyEvent keyEvent, boolean pressed) {
        int code = this.convertKeyCode(keyEvent.getID());
        char keyChar = keyEvent.getKeyChar();
        final KeyInputEvent event = new KeyInputEvent(code, keyChar, pressed, false);
        event.setTime(this.getInputTimeNanos());
        EXECUTOR.addToExecute(new Runnable(){

            @Override
            public void run() {
                AWTKeyInput.this.keyInputEvents.add(event);
            }
        });
    }

    @Override
    protected void updateImpl() {
        while (!this.keyInputEvents.isEmpty()) {
            this.listener.onKeyEvent(this.keyInputEvents.poll());
        }
    }

    private int convertKeyCode(int keyCode) {
        Integer code = KEY_CODE_TO_JME.get(keyCode);
        return code == null ? 0 : code;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        System.out.println("Key typed " + e.getKeyChar());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        System.out.println("Key pressed " + e.getKeyChar());
        this.onKeyEvent(e, true);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        System.out.println("Key released " + e.getKeyChar());
        this.onKeyEvent(e, false);
    }

    static {
        KEY_CODE_TO_JME.put(27, 1);
        KEY_CODE_TO_JME.put(48, 11);
        KEY_CODE_TO_JME.put(49, 2);
        KEY_CODE_TO_JME.put(50, 3);
        KEY_CODE_TO_JME.put(51, 4);
        KEY_CODE_TO_JME.put(52, 5);
        KEY_CODE_TO_JME.put(53, 6);
        KEY_CODE_TO_JME.put(54, 7);
        KEY_CODE_TO_JME.put(55, 8);
        KEY_CODE_TO_JME.put(56, 9);
        KEY_CODE_TO_JME.put(57, 10);
        KEY_CODE_TO_JME.put(45, 12);
        KEY_CODE_TO_JME.put(61, 13);
        KEY_CODE_TO_JME.put(8, 14);
        KEY_CODE_TO_JME.put(9, 15);
        KEY_CODE_TO_JME.put(81, 16);
        KEY_CODE_TO_JME.put(87, 17);
        KEY_CODE_TO_JME.put(69, 18);
        KEY_CODE_TO_JME.put(82, 19);
        KEY_CODE_TO_JME.put(84, 20);
        KEY_CODE_TO_JME.put(85, 22);
        KEY_CODE_TO_JME.put(73, 23);
        KEY_CODE_TO_JME.put(79, 24);
        KEY_CODE_TO_JME.put(80, 25);
        KEY_CODE_TO_JME.put(91, 26);
        KEY_CODE_TO_JME.put(93, 27);
        KEY_CODE_TO_JME.put(10, 28);
        KEY_CODE_TO_JME.put(17, 29);
        KEY_CODE_TO_JME.put(65, 30);
        KEY_CODE_TO_JME.put(83, 31);
        KEY_CODE_TO_JME.put(68, 32);
        KEY_CODE_TO_JME.put(70, 33);
        KEY_CODE_TO_JME.put(71, 34);
        KEY_CODE_TO_JME.put(72, 35);
        KEY_CODE_TO_JME.put(74, 36);
        KEY_CODE_TO_JME.put(89, 21);
        KEY_CODE_TO_JME.put(75, 37);
        KEY_CODE_TO_JME.put(76, 38);
        KEY_CODE_TO_JME.put(59, 39);
        KEY_CODE_TO_JME.put(222, 40);
        KEY_CODE_TO_JME.put(128, 41);
        KEY_CODE_TO_JME.put(16, 42);
        KEY_CODE_TO_JME.put(92, 43);
        KEY_CODE_TO_JME.put(90, 44);
        KEY_CODE_TO_JME.put(88, 45);
        KEY_CODE_TO_JME.put(67, 46);
        KEY_CODE_TO_JME.put(86, 47);
        KEY_CODE_TO_JME.put(66, 48);
        KEY_CODE_TO_JME.put(78, 49);
        KEY_CODE_TO_JME.put(77, 50);
        KEY_CODE_TO_JME.put(44, 51);
        KEY_CODE_TO_JME.put(46, 52);
        KEY_CODE_TO_JME.put(47, 53);
        KEY_CODE_TO_JME.put(106, 55);
        KEY_CODE_TO_JME.put(32, 57);
        KEY_CODE_TO_JME.put(20, 58);
        KEY_CODE_TO_JME.put(112, 59);
        KEY_CODE_TO_JME.put(113, 60);
        KEY_CODE_TO_JME.put(114, 61);
        KEY_CODE_TO_JME.put(115, 62);
        KEY_CODE_TO_JME.put(116, 63);
        KEY_CODE_TO_JME.put(117, 64);
        KEY_CODE_TO_JME.put(118, 65);
        KEY_CODE_TO_JME.put(119, 66);
        KEY_CODE_TO_JME.put(120, 67);
        KEY_CODE_TO_JME.put(121, 68);
        KEY_CODE_TO_JME.put(144, 69);
        KEY_CODE_TO_JME.put(145, 70);
        KEY_CODE_TO_JME.put(103, 71);
        KEY_CODE_TO_JME.put(104, 72);
        KEY_CODE_TO_JME.put(105, 73);
        KEY_CODE_TO_JME.put(109, 74);
        KEY_CODE_TO_JME.put(100, 75);
        KEY_CODE_TO_JME.put(101, 76);
        KEY_CODE_TO_JME.put(102, 77);
        KEY_CODE_TO_JME.put(107, 78);
        KEY_CODE_TO_JME.put(97, 79);
        KEY_CODE_TO_JME.put(98, 80);
        KEY_CODE_TO_JME.put(99, 81);
        KEY_CODE_TO_JME.put(96, 82);
        KEY_CODE_TO_JME.put(110, 83);
        KEY_CODE_TO_JME.put(122, 87);
        KEY_CODE_TO_JME.put(123, 88);
        KEY_CODE_TO_JME.put(61440, 100);
        KEY_CODE_TO_JME.put(61441, 101);
        KEY_CODE_TO_JME.put(61442, 102);
        KEY_CODE_TO_JME.put(21, 112);
        KEY_CODE_TO_JME.put(28, 121);
        KEY_CODE_TO_JME.put(29, 123);
        KEY_CODE_TO_JME.put(514, 144);
        KEY_CODE_TO_JME.put(512, 145);
        KEY_CODE_TO_JME.put(513, 146);
        KEY_CODE_TO_JME.put(523, 147);
        KEY_CODE_TO_JME.put(65480, 149);
        KEY_CODE_TO_JME.put(111, 181);
        KEY_CODE_TO_JME.put(19, 197);
        KEY_CODE_TO_JME.put(36, 199);
        KEY_CODE_TO_JME.put(38, 200);
        KEY_CODE_TO_JME.put(33, 201);
        KEY_CODE_TO_JME.put(37, 203);
        KEY_CODE_TO_JME.put(39, 205);
        KEY_CODE_TO_JME.put(35, 207);
        KEY_CODE_TO_JME.put(40, 208);
        KEY_CODE_TO_JME.put(34, 209);
        KEY_CODE_TO_JME.put(155, 210);
        KEY_CODE_TO_JME.put(127, 211);
        KEY_CODE_TO_JME.put(18, 56);
        KEY_CODE_TO_JME.put(157, 157);
    }
}

