/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.navigation;

import com.jme3.math.Vector3f;
import java.text.DecimalFormat;
import jme3tools.navigation.InvalidPositionException;
import jme3tools.navigation.NavCalculator;
import jme3tools.navigation.Position;

public class MapModel3D {
    private static final double RADIANS_PER_DEGREE = 57.2957;
    private static final double DEGREES_PER_RADIAN = 0.0174532925;
    public static final int DEFAULT_MAP_WIDTH_LONGITUDE = 360;
    private Position centre;
    private int xCentre;
    private int zCentre;
    private int worldWidth;
    private int worldHeight;
    private double minutesPerWorldUnit;

    public MapModel3D(int worldWidth) {
        try {
            this.centre = new Position(0.0, 0.0);
        }
        catch (InvalidPositionException e) {
            e.printStackTrace();
        }
        this.worldWidth = worldWidth;
        this.calculateMinutesPerWorldUnit(360.0);
        this.worldHeight = (int)NavCalculator.computeDMPClarkeSpheroid(0.0, 85.0) / (int)this.minutesPerWorldUnit * 2;
        this.xCentre = 0;
        this.zCentre = 0;
    }

    public int getWorldHeight() {
        return this.worldHeight;
    }

    public void calculateMinutesPerWorldUnit(double mapWidthInLongitude) {
        this.minutesPerWorldUnit = mapWidthInLongitude * 60.0 / (double)this.worldWidth;
    }

    public int getWorldWidth() {
        return this.worldWidth;
    }

    public void setWorldWidth(int viewportWidth) {
        this.worldWidth = viewportWidth;
    }

    public void setWorldHeight(int viewportHeight) {
        this.worldHeight = viewportHeight;
    }

    public void setCentre(Position centre) {
        this.centre = centre;
    }

    public double getMinutesPerWu() {
        return this.minutesPerWorldUnit;
    }

    public double getMetersPerWu() {
        return 1853.0 * this.minutesPerWorldUnit;
    }

    public Vector3f toWorldUnit(Position position) {
        double distance = NavCalculator.computeLongDiff(this.centre.getLongitude(), position.getLongitude());
        double distanceInPixels = distance / this.minutesPerWorldUnit;
        double dmp = NavCalculator.computeDMPClarkeSpheroid(this.centre.getLatitude(), position.getLatitude());
        int x = 0;
        int z = 0;
        if (this.centre.getLatitude() == position.getLatitude()) {
            z = this.zCentre;
        }
        if (this.centre.getLongitude() == position.getLongitude()) {
            x = this.xCentre;
        }
        if (this.centre.getLatitude() > 0.0 && position.getLatitude() > this.centre.getLatitude()) {
            z = this.zCentre - (int)(dmp / this.minutesPerWorldUnit);
        } else if (this.centre.getLatitude() > 0.0 && position.getLatitude() < this.centre.getLatitude()) {
            z = this.zCentre + (int)(dmp / this.minutesPerWorldUnit);
        } else if (this.centre.getLatitude() < 0.0 && position.getLatitude() > this.centre.getLatitude()) {
            z = this.zCentre - (int)(dmp / this.minutesPerWorldUnit);
        } else if (this.centre.getLatitude() < 0.0 && position.getLatitude() < this.centre.getLatitude()) {
            z = this.zCentre + (int)(dmp / this.minutesPerWorldUnit);
        } else if (this.centre.getLatitude() == 0.0 && position.getLatitude() > this.centre.getLatitude()) {
            z = this.zCentre - (int)(dmp / this.minutesPerWorldUnit);
        } else if (this.centre.getLatitude() == 0.0 && position.getLatitude() < this.centre.getLatitude()) {
            z = this.zCentre + (int)(dmp / this.minutesPerWorldUnit);
        }
        if (this.centre.getLongitude() < 0.0 && position.getLongitude() < this.centre.getLongitude()) {
            x = this.xCentre - (int)distanceInPixels;
        } else if (this.centre.getLongitude() < 0.0 && position.getLongitude() > this.centre.getLongitude()) {
            x = this.xCentre + (int)distanceInPixels;
        } else if (this.centre.getLongitude() > 0.0 && position.getLongitude() < this.centre.getLongitude()) {
            x = this.xCentre - (int)distanceInPixels;
        } else if (this.centre.getLongitude() > 0.0 && position.getLongitude() > this.centre.getLongitude()) {
            x = this.xCentre + (int)distanceInPixels;
        } else if (this.centre.getLongitude() == 0.0 && position.getLongitude() > this.centre.getLongitude()) {
            x = this.xCentre + (int)distanceInPixels;
        } else if (this.centre.getLongitude() == 0.0 && position.getLongitude() < this.centre.getLongitude()) {
            x = this.xCentre - (int)distanceInPixels;
        }
        return new Vector3f((float)x, 0.0f, (float)z);
    }

    public Position toPosition(Vector3f posVec) {
        Position pos = null;
        try {
            double lon;
            double lat;
            Vector3f worldCentre = this.toWorldUnit(new Position(0.0, 0.0));
            double xDistance = this.difference(this.xCentre, posVec.getX());
            double yDistance = this.difference(worldCentre.getZ(), posVec.getZ());
            double lonDistanceInDegrees = xDistance * this.minutesPerWorldUnit / 60.0;
            double mp = yDistance * this.minutesPerWorldUnit;
            if (this.getMinutesPerWu() < 0.05) {
                lat = this.findLat(mp, this.getCentre().getLatitude());
                if (lat == -1000.0) {
                    System.out.println("lat: " + lat);
                }
            } else {
                lat = this.findLat(mp, 0.0, 85.0);
            }
            double d = lon = posVec.getX() < (float)this.xCentre ? this.centre.getLongitude() - lonDistanceInDegrees : this.centre.getLongitude() + lonDistanceInDegrees;
            if (posVec.getZ() > worldCentre.getZ()) {
                lat = -1.0 * lat;
            }
            if (lat == -1000.0 || lon == -1000.0) {
                return pos;
            }
            pos = new Position(lat, lon);
        }
        catch (InvalidPositionException ipe) {
            ipe.printStackTrace();
        }
        return pos;
    }

    private double difference(double a, double b) {
        return Math.abs(a - b);
    }

    public void setCentre(Vector3f posVec) {
        try {
            Position newCentre = this.toPosition(posVec);
            if (newCentre != null) {
                this.centre = newCentre;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Vector3f getCentreWu() {
        return new Vector3f((float)this.xCentre, 0.0f, (float)this.zCentre);
    }

    public Position getCentre() {
        return this.centre;
    }

    private double findLat(double mp, double low, double high) {
        DecimalFormat form = new DecimalFormat("#.####");
        mp = Math.round(mp);
        double midLat = (low + high) / 2.0;
        double guessMP = NavCalculator.computeDMPClarkeSpheroid(0.0, (float)midLat);
        while (low <= high) {
            if (guessMP == mp) {
                return midLat;
            }
            if (guessMP > mp) {
                high = midLat - 1.0E-4;
            } else {
                low = midLat + 1.0E-4;
            }
            midLat = Double.valueOf(form.format((low + high) / 2.0));
            guessMP = NavCalculator.computeDMPClarkeSpheroid(0.0, (float)midLat);
            guessMP = Math.round(guessMP);
        }
        return -1000.0;
    }

    private double findLat(double mp, double previousLat) {
        DecimalFormat form = new DecimalFormat("#.#####");
        mp = Double.parseDouble(form.format(mp));
        for (double lat = previousLat - 0.25; lat < previousLat + 1.0; lat += 1.0E-5) {
            double guessMP = NavCalculator.computeDMPClarkeSpheroid(0.0, lat);
            if ((guessMP = Double.parseDouble(form.format(guessMP))) != mp && !(Math.abs(guessMP - mp) < 0.05)) continue;
            return lat;
        }
        return -1000.0;
    }
}

